/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import software.amazon.kinesis.common.InitialPositionInStream;

class StartingPoint
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized InitialPositionInStream position;
    private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

    public StartingPoint(@UnknownKeyFor @NonNull @Initialized InitialPositionInStream position) {
        this.position = (InitialPositionInStream)Preconditions.checkNotNull((Object)position, (Object)"position");
        this.timestamp = null;
    }

    public StartingPoint(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        this.timestamp = (Instant)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.position = InitialPositionInStream.AT_TIMESTAMP;
    }

    public @UnknownKeyFor @NonNull @Initialized InitialPositionInStream getPosition() {
        return this.position;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPositionName() {
        return this.position.name();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
        return this.timestamp;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartingPoint that = (StartingPoint)o;
        return this.position == that.position && Objects.equals(this.timestamp, that.timestamp);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.position, this.timestamp);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        if (this.timestamp == null) {
            return this.position.toString();
        }
        return "Starting at timestamp " + this.timestamp;
    }
}

