/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.sns.AutoValue_SnsIO_Write;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public final class SnsIO {
    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_SnsIO_Write.Builder().setClientConfiguration(ClientConfiguration.builder().build()).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<PublishResponse>> {
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized String getTopicArn();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PublishRequest.Builder> getPublishRequestBuilder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTopicArn(@UnknownKeyFor @NonNull @Initialized String topicArn) {
            return this.builder().setTopicArn(topicArn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPublishRequestBuilder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PublishRequest.Builder> requestBuilder) {
            return this.builder().setPublishRequestBuilder(requestBuilder).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write<T> withPublishRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized PublishRequest> publishRequestFn) {
            return this.builder().setPublishRequestBuilder((SerializableFunction & Serializable)m -> ((PublishRequest)publishRequestFn.apply(m)).toBuilder()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.builder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PublishResponse> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkArgument((this.getPublishRequestBuilder() != null ? 1 : 0) != 0, (Object)"withPublishRequestBuilder() is required");
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            Preconditions.checkArgument((this.getClientConfiguration() != null ? 1 : 0) != 0, (Object)"withClientConfiguration() is required");
            ClientBuilderFactory.validate(awsOptions, this.getClientConfiguration());
            if (this.getTopicArn() != null) {
                Preconditions.checkArgument((boolean)this.checkTopicExists(awsOptions), (String)"Topic arn %s does not exist", (Object)this.getTopicArn());
            }
            return (PCollection)input.apply((PTransform)ParDo.of(new SnsWriterFn(this)));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private @UnknownKeyFor @NonNull @Initialized boolean checkTopicExists(@UnknownKeyFor @NonNull @Initialized AwsOptions options) {
            try (SnsClient client = this.buildClient(options);){
                client.getTopicAttributes(b -> b.topicArn(this.getTopicArn()));
                boolean bl = true;
                return bl;
            }
            catch (InvalidParameterException | NotFoundException e) {
                LoggerFactory.getLogger(Write.class).warn("Configured topic ARN '" + this.getTopicArn() + "' does not exist.", e);
                return false;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized SnsClient buildClient(@UnknownKeyFor @NonNull @Initialized AwsOptions options) {
            return (SnsClient)ClientBuilderFactory.buildClient((AwsOptions)options.as(AwsOptions.class), SnsClient.builder(), this.getClientConfiguration());
        }

        static class SnsWriterFn<@UnknownKeyFor T>
        extends DoFn<T, PublishResponse> {
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SnsWriterFn.class);
            private static final @UnknownKeyFor @NonNull @Initialized Counter SNS_WRITE_FAILURES = Metrics.counter(SnsWriterFn.class, (String)"SNS_Write_Failures");
            private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
            private transient @UnknownKeyFor @NonNull @Initialized SnsClient producer;

            SnsWriterFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.producer = ((Write)this.spec).buildClient((AwsOptions)options.as(AwsOptions.class));
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                PublishRequest.Builder reqBuilder = (PublishRequest.Builder)this.spec.getPublishRequestBuilder().apply(context.element());
                if (this.spec.getTopicArn() != null) {
                    reqBuilder.topicArn(this.spec.getTopicArn());
                }
                PublishRequest request = (PublishRequest)reqBuilder.build();
                try {
                    PublishResponse pr = this.producer.publish(request);
                    context.output((Object)pr);
                }
                catch (SdkException e) {
                    SNS_WRITE_FAILURES.inc();
                    LOG.error("Unable to publish message {}.", (Object)request.message());
                    throw e;
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTopicArn(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPublishRequestBuilder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized PublishRequest.Builder> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }
}

