/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;

final class AutoValue_SqsMessage
extends SqsMessage {
    private final String body;
    private final String messageId;
    private final String receiptHandle;
    private final long timeStamp;
    private final long requestTimeStamp;

    private AutoValue_SqsMessage(String body, String messageId, String receiptHandle, long timeStamp, long requestTimeStamp) {
        this.body = body;
        this.messageId = messageId;
        this.receiptHandle = receiptHandle;
        this.timeStamp = timeStamp;
        this.requestTimeStamp = requestTimeStamp;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getRequestTimeStamp() {
        return this.requestTimeStamp;
    }

    public String toString() {
        return "SqsMessage{body=" + this.body + ", messageId=" + this.messageId + ", receiptHandle=" + this.receiptHandle + ", timeStamp=" + this.timeStamp + ", requestTimeStamp=" + this.requestTimeStamp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqsMessage) {
            SqsMessage that = (SqsMessage)o;
            return this.body.equals(that.getBody()) && this.messageId.equals(that.getMessageId()) && this.receiptHandle.equals(that.getReceiptHandle()) && this.timeStamp == that.getTimeStamp() && this.requestTimeStamp == that.getRequestTimeStamp();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.body.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageId.hashCode();
        h$ *= 1000003;
        h$ ^= this.receiptHandle.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.timeStamp >>> 32 ^ this.timeStamp);
        h$ *= 1000003;
        return h$ ^= (int)(this.requestTimeStamp >>> 32 ^ this.requestTimeStamp);
    }

    @Override
    SqsMessage.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SqsMessage.Builder {
        private String body;
        private String messageId;
        private String receiptHandle;
        private Long timeStamp;
        private Long requestTimeStamp;

        Builder() {
        }

        private Builder(SqsMessage source) {
            this.body = source.getBody();
            this.messageId = source.getMessageId();
            this.receiptHandle = source.getReceiptHandle();
            this.timeStamp = source.getTimeStamp();
            this.requestTimeStamp = source.getRequestTimeStamp();
        }

        @Override
        SqsMessage.Builder setBody(String body) {
            if (body == null) {
                throw new NullPointerException("Null body");
            }
            this.body = body;
            return this;
        }

        @Override
        SqsMessage.Builder setMessageId(String messageId) {
            if (messageId == null) {
                throw new NullPointerException("Null messageId");
            }
            this.messageId = messageId;
            return this;
        }

        @Override
        SqsMessage.Builder setReceiptHandle(String receiptHandle) {
            if (receiptHandle == null) {
                throw new NullPointerException("Null receiptHandle");
            }
            this.receiptHandle = receiptHandle;
            return this;
        }

        @Override
        SqsMessage.Builder setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        @Override
        SqsMessage.Builder setRequestTimeStamp(long requestTimeStamp) {
            this.requestTimeStamp = requestTimeStamp;
            return this;
        }

        @Override
        SqsMessage build() {
            if (this.body == null || this.messageId == null || this.receiptHandle == null || this.timeStamp == null || this.requestTimeStamp == null) {
                StringBuilder missing = new StringBuilder();
                if (this.body == null) {
                    missing.append(" body");
                }
                if (this.messageId == null) {
                    missing.append(" messageId");
                }
                if (this.receiptHandle == null) {
                    missing.append(" receiptHandle");
                }
                if (this.timeStamp == null) {
                    missing.append(" timeStamp");
                }
                if (this.requestTimeStamp == null) {
                    missing.append(" requestTimeStamp");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqsMessage(this.body, this.messageId, this.receiptHandle, this.timeStamp, this.requestTimeStamp);
        }
    }
}

