/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.specialized.BlobInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class AzureReadableSeekableByteChannel
implements SeekableByteChannel {
    private final BlobInputStream inputStream;
    private boolean closed;
    private final Long contentLength;
    private long position = 0L;

    public AzureReadableSeekableByteChannel(BlobClient blobClient) {
        this.inputStream = blobClient.openInputStream();
        this.contentLength = blobClient.getProperties().getBlobSize();
        this.inputStream.mark(this.contentLength.intValue());
        this.closed = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        int read = 0;
        if (dst.hasArray()) {
            read = this.inputStream.read(dst.array(), dst.position() + dst.arrayOffset(), dst.remaining());
        } else {
            byte[] myarray = new byte[dst.remaining()];
            read = this.inputStream.read(myarray, 0, myarray.length);
            dst.put(myarray);
        }
        if (read > 0) {
            dst.position(dst.position() + read);
        }
        return read;
    }

    @Override
    public int write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"newPosition too low");
        Preconditions.checkArgument((newPosition < this.contentLength ? 1 : 0) != 0, (Object)"new position too high");
        Long bytesToSkip = newPosition - this.position;
        if (bytesToSkip < 0L) {
            this.inputStream.reset();
            bytesToSkip = newPosition;
        }
        Long n = this.inputStream.skip(bytesToSkip.longValue());
        this.position += n.longValue();
        return this;
    }

    @Override
    public long size() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.contentLength;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }
}

