/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import org.apache.beam.sdk.io.azure.options.BlobstoreClientBuilderFactory;
import org.apache.beam.sdk.io.azure.options.BlobstoreOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;

public class DefaultBlobstoreClientBuilderFactory
implements BlobstoreClientBuilderFactory {
    @Override
    public BlobServiceClientBuilder createBuilder(BlobstoreOptions blobstoreOptions) {
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
        if (!Strings.isNullOrEmpty((String)blobstoreOptions.getAzureConnectionString())) {
            builder = builder.connectionString(blobstoreOptions.getAzureConnectionString());
        }
        if (blobstoreOptions.getAzureCredentialsProvider() != null) {
            builder = builder.credential(blobstoreOptions.getAzureCredentialsProvider());
        }
        if (!Strings.isNullOrEmpty((String)blobstoreOptions.getSasToken())) {
            builder = builder.sasToken(blobstoreOptions.getSasToken());
        }
        if (!Strings.isNullOrEmpty((String)blobstoreOptions.getAccountName()) && !Strings.isNullOrEmpty((String)blobstoreOptions.getAccessKey())) {
            StorageSharedKeyCredential credential = new StorageSharedKeyCredential(blobstoreOptions.getAccountName(), blobstoreOptions.getAccessKey());
            builder = builder.credential(credential);
        }
        if (!Strings.isNullOrEmpty((String)blobstoreOptions.getBlobServiceEndpoint())) {
            builder = builder.endpoint(blobstoreOptions.getBlobServiceEndpoint());
        }
        if (blobstoreOptions.getCustomerProvidedKey() != null) {
            builder = builder.customerProvidedKey(blobstoreOptions.getCustomerProvidedKey());
        }
        if (blobstoreOptions.getPipelinePolicy() != null) {
            builder = builder.addPolicy(blobstoreOptions.getPipelinePolicy());
        }
        if (blobstoreOptions.getHttpClient() != null) {
            builder = builder.httpClient(blobstoreOptions.getHttpClient());
        }
        if (blobstoreOptions.getHttpPipeline() != null) {
            builder = builder.pipeline(blobstoreOptions.getHttpPipeline());
        }
        return builder;
    }
}

