/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.options;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.models.CustomerProvidedKey;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.azure.blobstore.DefaultBlobstoreClientBuilderFactory;
import org.apache.beam.sdk.io.azure.options.BlobstoreClientBuilderFactory;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public interface BlobstoreOptions
extends PipelineOptions {
    @Description(value="Factory class that should be created and used to create a builder of Azure Blobstore client.Override the default value if you need a Azure client with custom properties.")
    @Default.Class(value=DefaultBlobstoreClientBuilderFactory.class)
    public Class<? extends BlobstoreClientBuilderFactory> getBlobstoreClientFactoryClass();

    public void setBlobstoreClientFactoryClass(Class<? extends BlobstoreClientBuilderFactory> var1);

    @Description(value="Adds a pipeline policy to apply on each request sent to the blob service client.")
    public @Nullable HttpPipelinePolicy getPipelinePolicy();

    public void setPipelinePolicy(HttpPipelinePolicy var1);

    @Description(value="Sets the connection string to connect to the Azure Blobstore client.")
    public String getAzureConnectionString();

    public void setAzureConnectionString(String var1);

    @Description(value="Sets the SAS token used to authorize requests sent to the service.")
    public String getSasToken();

    public void setSasToken(String var1);

    @Description(value="Blobstore account name")
    public String getAccountName();

    public void setAccountName(String var1);

    @Description(value="Azure Blobstore access key")
    public String getAccessKey();

    public void setAccessKey(String var1);

    @Description(value="Sets the customer provided key that is used to encrypt blob contents on the server.")
    public CustomerProvidedKey getCustomerProvidedKey();

    public void setCustomerProvidedKey(CustomerProvidedKey var1);

    @Description(value="Sets the blob service endpoint, additionally parses it for information (SAS token)")
    public @Nullable String getBlobServiceEndpoint();

    public void setBlobServiceEndpoint(String var1);

    @Description(value="Sets the HttpClient to use for sending a receiving requests to and from the service.")
    public @Nullable HttpClient getHttpClient();

    public void setHttpClient(HttpClient var1);

    @Description(value="Sets the HttpPipeline to use for the service client.")
    public @Nullable HttpPipeline getHttpPipeline();

    public void setHttpPipeline(HttpPipeline var1);

    @Description(value="The credential instance that should be used to authenticate against Azure services. The option value must contain \"@type\" field and an Azure credentials provider class name as the field value.  For example, to specify the Azure client id, tenant id, and client secret, specify the following: {\"@type\" : \"ClientSecretCredential\", \"azureClientId\": \"client_id_value\", \"azureTenantId\": \"tenant_id_value\", \"azureClientSecret\": \"client_secret_value\"}")
    @Default.InstanceFactory(value=AzureUserCredentialsFactory.class)
    public TokenCredential getAzureCredentialsProvider();

    public void setAzureCredentialsProvider(TokenCredential var1);

    public static class AzureUserCredentialsFactory
    implements DefaultValueFactory<TokenCredential> {
        public TokenCredential create(PipelineOptions options) {
            return new DefaultAzureCredentialBuilder().build();
        }
    }
}

