/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.cassandra.CassandraIO;
import org.apache.beam.sdk.options.ValueProvider;

public class ConnectionManager {
    private static final ConcurrentHashMap<String, Cluster> clusterMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Session> sessionMap = new ConcurrentHashMap();

    private static String readToClusterHash(CassandraIO.Read<?> read) {
        return ((List)Objects.requireNonNull(read.hosts()).get()).stream().reduce(",", (a, b) -> a + b) + Objects.requireNonNull(read.port()).get() + ConnectionManager.safeVPGet(read.localDc()) + ConnectionManager.safeVPGet(read.consistencyLevel());
    }

    private static String readToSessionHash(CassandraIO.Read<?> read) {
        return ConnectionManager.readToClusterHash(read) + (String)read.keyspace().get();
    }

    static Session getSession(CassandraIO.Read<?> read) {
        Cluster cluster = clusterMap.computeIfAbsent(ConnectionManager.readToClusterHash(read), k -> CassandraIO.getCluster(Objects.requireNonNull(read.hosts()), Objects.requireNonNull(read.port()), read.username(), read.password(), read.localDc(), read.consistencyLevel(), read.connectTimeout(), read.readTimeout()));
        return sessionMap.computeIfAbsent(ConnectionManager.readToSessionHash(read), k -> cluster.connect((String)Objects.requireNonNull(read.keyspace()).get()));
    }

    private static String safeVPGet(ValueProvider<String> s) {
        return s != null ? (String)s.get() : "";
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Session session : sessionMap.values()) {
                if (session.isClosed()) continue;
                session.close();
            }
        }));
    }
}

