/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.contextualtextio.AutoValue_ContextualTextIO_Read;
import org.apache.beam.sdk.io.contextualtextio.AutoValue_ContextualTextIO_ReadFiles;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIOSource;
import org.apache.beam.sdk.io.contextualtextio.RecordWithMetadata;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualTextIO {
    private static final long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;
    private static final Logger LOG = LoggerFactory.getLogger(ContextualTextIO.class);

    public static Read read() {
        return new AutoValue_ContextualTextIO_Read.Builder().setCompression(Compression.AUTO).setHintMatchesManyFiles(false).setWithRecordNumMetadata(false).setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.DISALLOW)).setHasMultilineCSVRecords(false).build();
    }

    public static ReadFiles readFiles() {
        return new AutoValue_ContextualTextIO_ReadFiles.Builder().setDesiredBundleSizeBytes(0x4000000L).setHasMultilineCSVRecords(false).setWithRecordNumMetadata(false).build();
    }

    private ContextualTextIO() {
    }

    private static class ProcessRecordNumbers
    extends PTransform<PCollection<Row>, PCollection<Row>> {
        private ProcessRecordNumbers() {
        }

        public PCollection<Row> expand(PCollection<Row> records) {
            Trigger currentTrigger = records.getWindowingStrategy().getTrigger();
            ImmutableSet allowedTriggers = ImmutableSet.of((Object)Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow()), (Object)DefaultTrigger.of());
            Preconditions.checkArgument((boolean)allowedTriggers.contains(currentTrigger), (Object)String.format("getWithRecordNumMetadata(true) only supports the default trigger not: %s", currentTrigger));
            PCollection recordsGroupedByFileAndRange = ((PCollection)records.apply("AddFileNameAndRange", (PTransform)ParDo.of((DoFn)new Read.AddFileNameAndRange()))).setCoder((Coder)KvCoder.of((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianLongCoder.of()), (Coder)RowCoder.of((Schema)RecordWithMetadata.getSchema())));
            PCollectionView rangeSizes = (PCollectionView)((PCollection)((PCollection)recordsGroupedByFileAndRange.apply("CountRecordsForEachFileRange", Count.perKey())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.longs(), (TypeDescriptor)TypeDescriptors.longs()))).via((SerializableFunction & Serializable)x -> KV.of((Object)((String)((KV)x.getKey()).getKey()), (Object)KV.of((Object)((Long)((KV)x.getKey()).getValue()), (Object)((Long)x.getValue())))))).apply("SizesAsView", (PTransform)View.asMultimap());
            PCollection singletonPcoll = (PCollection)records.getPipeline().apply("CreateSingletonPcoll", (PTransform)Create.of(Arrays.asList(1)));
            PCollectionView numRecordsBeforeEachRange = (PCollectionView)((PCollection)singletonPcoll.apply("ComputeNumRecordsBeforeRange", (PTransform)ParDo.of((DoFn)new Read.ComputeRecordsBeforeEachRange((PCollectionView<Map<String, Iterable<KV<Long, Long>>>>)rangeSizes)).withSideInputs(new PCollectionView[]{rangeSizes}))).apply("NumRecordsBeforeEachRangeAsView", (PTransform)View.asMultimap());
            return ((PCollection)recordsGroupedByFileAndRange.apply("AssignLineNums", (PTransform)ParDo.of((DoFn)new Read.AssignRecordNums((PCollectionView<Map<String, Iterable<KV<Long, Long>>>>)numRecordsBeforeEachRange)).withSideInputs(new PCollectionView[]{numRecordsBeforeEachRange}))).setRowSchema(RecordWithMetadata.getSchema());
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<Row>> {
        abstract long getDesiredBundleSizeBytes();

        abstract byte @Nullable [] getDelimiter();

        abstract boolean getHasMultilineCSVRecords();

        abstract boolean getWithRecordNumMetadata();

        abstract Builder toBuilder();

        @VisibleForTesting
        ReadFiles withDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        @VisibleForTesting
        ReadFiles withRecordNumMetadata() {
            return this.toBuilder().setWithRecordNumMetadata(true).build();
        }

        public ReadFiles withDelimiter(byte[] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public PCollection<Row> expand(PCollection<FileIO.ReadableFile> input) {
            PCollection rows = (PCollection)input.apply("Read all via FileBasedSource", (PTransform)new ReadAllViaFileBasedSource(this.getDesiredBundleSizeBytes(), (SerializableFunction)new CreateTextSourceFn(this.getDelimiter(), this.getHasMultilineCSVRecords()), (Coder)SchemaCoder.of((Schema)RecordWithMetadata.getSchema())));
            if (!this.getWithRecordNumMetadata()) {
                return rows;
            }
            return (PCollection)rows.apply((PTransform)new ProcessRecordNumbers());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"delimiter", (String)Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        private static class CreateTextSourceFn
        implements SerializableFunction<String, FileBasedSource<Row>> {
            private byte[] delimiter;
            private boolean hasMultilineCSVRecords;

            private CreateTextSourceFn(byte[] delimiter, boolean hasMultilineCSVRecords) {
                this.delimiter = delimiter;
                this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            }

            public FileBasedSource<Row> apply(String input) {
                return new ContextualTextIOSource((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input), EmptyMatchTreatment.DISALLOW, this.delimiter, this.hasMultilineCSVRecords);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDesiredBundleSizeBytes(long var1);

            abstract Builder setHasMultilineCSVRecords(boolean var1);

            abstract Builder setWithRecordNumMetadata(boolean var1);

            abstract Builder setDelimiter(byte @Nullable [] var1);

            abstract ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Row>> {
        abstract @Nullable ValueProvider<String> getFilepattern();

        abstract FileIO.MatchConfiguration getMatchConfiguration();

        abstract boolean getHintMatchesManyFiles();

        abstract boolean getWithRecordNumMetadata();

        abstract Compression getCompression();

        abstract @Nullable Boolean getHasMultilineCSVRecords();

        abstract byte @Nullable [] getDelimiter();

        abstract Builder toBuilder();

        public Read from(String filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Read from(ValueProvider<String> filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read withMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        public Read withHasMultilineCSVRecords(Boolean hasMultilineCSVRecords) {
            return this.toBuilder().setHasMultilineCSVRecords(hasMultilineCSVRecords).build();
        }

        public Read withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public Read withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public Read withRecordNumMetadata() {
            return this.toBuilder().setWithRecordNumMetadata(true).build();
        }

        public Read withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public Read withDelimiter(byte[] delimiter) {
            Preconditions.checkArgument((delimiter != null ? 1 : 0) != 0, (Object)"delimiter can not be null");
            Preconditions.checkArgument((!Read.isSelfOverlapping(delimiter) ? 1 : 0) != 0, (Object)"delimiter must not self-overlap");
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        static boolean isSelfOverlapping(byte[] s) {
            for (int i = 1; i < s.length - 1; ++i) {
                if (!ByteBuffer.wrap(s, 0, i).equals(ByteBuffer.wrap(s, s.length - i, i))) continue;
                return true;
            }
            return false;
        }

        public PCollection<Row> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (Object)"need to set the filepattern of a ContextualTextIO.Read transform");
            PCollection records = null;
            records = this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles() ? (PCollection)input.apply("Read", (PTransform)org.apache.beam.sdk.io.Read.from(this.getSource())) : (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply("Match All", (PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply("Read Matches", (PTransform)FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply("Via ReadFiles", (PTransform)ContextualTextIO.readFiles().withDelimiter(this.getDelimiter()));
            if (!this.getWithRecordNumMetadata()) {
                return records;
            }
            return (PCollection)records.apply((PTransform)new ProcessRecordNumbers());
        }

        protected FileBasedSource<Row> getSource() {
            return CompressedSource.from((FileBasedSource)new ContextualTextIOSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getDelimiter(), this.getHasMultilineCSVRecords())).withCompression(this.getCompression());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"compressionType", (String)this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("File Pattern")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration()).addIfNotNull(DisplayData.item((String)"delimiter", (String)Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records")).addIfNotNull(DisplayData.item((String)"hasMultilineCSVRecords", (Boolean)this.getHasMultilineCSVRecords()).withLabel("Has RFC4180 MultiLineCSV Records"));
        }

        static class AssignRecordNums
        extends DoFn<KV<KV<String, Long>, Row>, Row> {
            PCollectionView<Map<String, Iterable<KV<Long, Long>>>> numRecordsBeforeEachRange;

            public AssignRecordNums(PCollectionView<Map<String, Iterable<KV<Long, Long>>>> numRecordsBeforeEachRange) {
                this.numRecordsBeforeEachRange = numRecordsBeforeEachRange;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext p) {
                String file = (String)((KV)((KV)p.element()).getKey()).getKey();
                Long offset = (Long)((KV)((KV)p.element()).getKey()).getValue();
                Row record = (Row)((KV)p.element()).getValue();
                Iterator<KV<Long, Long>> numRecordsBeforeEachOffsetInFile = ((Iterable)((Map)p.sideInput(this.numRecordsBeforeEachRange)).get(file)).iterator();
                Long numRecordsLessThanThisOffset = this.getNumRecordsBeforeOffset(offset, numRecordsBeforeEachOffsetInFile);
                Row newLine = Row.fromRow((Row)record).withFieldValue("recordNum", (Object)(record.getInt64("recordNumInOffset") + numRecordsLessThanThisOffset)).build();
                p.output((Object)newLine);
            }

            private Long getNumRecordsBeforeOffset(Long offset, Iterator<KV<Long, Long>> numRecordsBeforeEachOffsetInFile) {
                while (numRecordsBeforeEachOffsetInFile.hasNext()) {
                    KV<Long, Long> entry = numRecordsBeforeEachOffsetInFile.next();
                    if (!((Long)entry.getKey()).equals(offset)) continue;
                    return (Long)entry.getValue();
                }
                LOG.error("Unable to compute contextual metadata. Please report a bug in ContextualTextIO");
                return null;
            }
        }

        @VisibleForTesting
        static class ComputeRecordsBeforeEachRange
        extends DoFn<Integer, KV<String, KV<Long, Long>>> {
            private final PCollectionView<Map<String, Iterable<KV<Long, Long>>>> rangeSizes;

            public ComputeRecordsBeforeEachRange(PCollectionView<Map<String, Iterable<KV<Long, Long>>>> rangeSizes) {
                this.rangeSizes = rangeSizes;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext p) {
                Map rangeSizesMap = (Map)p.sideInput(this.rangeSizes);
                for (Map.Entry entrySet : rangeSizesMap.entrySet()) {
                    TreeMap sorted = new TreeMap(new FileRangeComparator());
                    ((Iterable)entrySet.getValue()).iterator().forEachRemaining(x -> sorted.put(KV.of((Object)((String)entrySet.getKey()), (Object)((Long)x.getKey())), (Long)x.getValue()));
                    HashMap<String, Long> pastRecords = new HashMap<String, Long>();
                    for (Map.Entry entry : sorted.entrySet()) {
                        Long numRecords = (Long)entry.getValue();
                        KV fileRange = (KV)entry.getKey();
                        String file = (String)fileRange.getKey();
                        Long numRecordsBefore = 0L;
                        if (pastRecords.containsKey(file)) {
                            numRecordsBefore = (Long)pastRecords.get(file);
                        }
                        p.output((Object)KV.of((Object)file, (Object)KV.of((Object)((Long)fileRange.getValue()), (Object)numRecordsBefore)));
                        pastRecords.put(file, numRecordsBefore + numRecords);
                    }
                }
            }

            private static class FileRangeComparator<K extends Comparable<K>, V extends Comparable<V>>
            implements Comparator<KV<K, V>>,
            Serializable {
                private FileRangeComparator() {
                }

                @Override
                public int compare(KV<K, V> a, KV<K, V> b) {
                    if (((Comparable)a.getKey()).compareTo((Comparable)b.getKey()) == 0) {
                        return ((Comparable)a.getValue()).compareTo((Comparable)b.getValue());
                    }
                    return ((Comparable)a.getKey()).compareTo((Comparable)b.getKey());
                }
            }
        }

        @VisibleForTesting
        static class AddFileNameAndRange
        extends DoFn<Row, KV<KV<String, Long>, Row>> {
            AddFileNameAndRange() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element Row record, DoFn.OutputReceiver<KV<KV<String, Long>, Row>> out) {
                out.output((Object)KV.of((Object)KV.of((Object)((ResourceId)record.getLogicalTypeValue("resourceId", ResourceId.class)).toString(), (Object)record.getInt64("rangeOffset")), (Object)record));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder setHintMatchesManyFiles(boolean var1);

            abstract Builder setWithRecordNumMetadata(boolean var1);

            abstract Builder setCompression(Compression var1);

            abstract Builder setDelimiter(byte @Nullable [] var1);

            abstract Builder setHasMultilineCSVRecords(Boolean var1);

            abstract Read build();
        }
    }
}

