/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RecordWithMetadata {
    public static final String VALUE = "value";
    public static final String RESOURCE_ID = "resourceId";
    public static final String RECORD_NUM = "recordNum";
    public static final String RANGE_OFFSET = "rangeOffset";
    public static final String RECORD_NUM_IN_OFFSET = "recordNumInOffset";
    public static final String RECORD_OFFSET = "recordOffset";

    public static Schema getSchema() {
        return Schema.builder().addStringField(VALUE).addLogicalTypeField(RESOURCE_ID, (Schema.LogicalType)new ResourceIdRow()).addNullableField(RECORD_NUM, Schema.FieldType.INT64).addInt64Field(RECORD_OFFSET).addInt64Field(RECORD_NUM_IN_OFFSET).addInt64Field(RANGE_OFFSET).build();
    }

    private static class ResourceIdRow
    implements Schema.LogicalType<ResourceId, Row> {
        private final Schema schema = Schema.builder().addStringField("resource").addBooleanField("is_directory").build();

        private ResourceIdRow() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Schema.FieldType getArgumentType() {
            return Schema.FieldType.STRING;
        }

        public String getArgument() {
            return "";
        }

        public String getIdentifier() {
            return "beam:logical_type:resource_id:v1";
        }

        public Schema.FieldType getBaseType() {
            return Schema.FieldType.row((Schema)this.schema);
        }

        public Row toBaseType(ResourceId resourceId) {
            return Row.withSchema((Schema)this.schema).withFieldValue("resource", (Object)resourceId.toString()).withFieldValue("is_directory", (Object)resourceId.isDirectory()).build();
        }

        public ResourceId toInputType(Row base) {
            Preconditions.checkNotNull((Object)base.getString("resource"));
            Preconditions.checkNotNull((Object)base.getBoolean("is_directory"));
            return FileSystems.matchNewResource((String)base.getString("resource"), (boolean)base.getBoolean("is_directory"));
        }
    }
}

