/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import java.util.Arrays;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIO;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ContextualTextIO_ReadFiles
extends ContextualTextIO.ReadFiles {
    private final long desiredBundleSizeBytes;
    private final byte @Nullable [] delimiter;
    private final boolean hasMultilineCSVRecords;
    private final boolean withRecordNumMetadata;

    private AutoValue_ContextualTextIO_ReadFiles(long desiredBundleSizeBytes, byte @Nullable [] delimiter, boolean hasMultilineCSVRecords, boolean withRecordNumMetadata) {
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
        this.delimiter = delimiter;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
        this.withRecordNumMetadata = withRecordNumMetadata;
    }

    @Override
    long getDesiredBundleSizeBytes() {
        return this.desiredBundleSizeBytes;
    }

    @Override
    byte @Nullable [] getDelimiter() {
        return this.delimiter;
    }

    @Override
    boolean getHasMultilineCSVRecords() {
        return this.hasMultilineCSVRecords;
    }

    @Override
    boolean getWithRecordNumMetadata() {
        return this.withRecordNumMetadata;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ContextualTextIO.ReadFiles) {
            ContextualTextIO.ReadFiles that = (ContextualTextIO.ReadFiles)((Object)o);
            return this.desiredBundleSizeBytes == that.getDesiredBundleSizeBytes() && Arrays.equals(this.delimiter, that instanceof AutoValue_ContextualTextIO_ReadFiles ? ((AutoValue_ContextualTextIO_ReadFiles)that).delimiter : that.getDelimiter()) && this.hasMultilineCSVRecords == that.getHasMultilineCSVRecords() && this.withRecordNumMetadata == that.getWithRecordNumMetadata();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.desiredBundleSizeBytes >>> 32 ^ this.desiredBundleSizeBytes);
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.delimiter);
        h$ *= 1000003;
        h$ ^= this.hasMultilineCSVRecords ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.withRecordNumMetadata ? 1231 : 1237;
    }

    @Override
    ContextualTextIO.ReadFiles.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ContextualTextIO.ReadFiles.Builder {
        private Long desiredBundleSizeBytes;
        private byte @Nullable [] delimiter;
        private Boolean hasMultilineCSVRecords;
        private Boolean withRecordNumMetadata;

        Builder() {
        }

        private Builder(ContextualTextIO.ReadFiles source) {
            this.desiredBundleSizeBytes = source.getDesiredBundleSizeBytes();
            this.delimiter = source.getDelimiter();
            this.hasMultilineCSVRecords = source.getHasMultilineCSVRecords();
            this.withRecordNumMetadata = source.getWithRecordNumMetadata();
        }

        @Override
        ContextualTextIO.ReadFiles.Builder setDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
            return this;
        }

        @Override
        ContextualTextIO.ReadFiles.Builder setDelimiter(byte @Nullable [] delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        ContextualTextIO.ReadFiles.Builder setHasMultilineCSVRecords(boolean hasMultilineCSVRecords) {
            this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            return this;
        }

        @Override
        ContextualTextIO.ReadFiles.Builder setWithRecordNumMetadata(boolean withRecordNumMetadata) {
            this.withRecordNumMetadata = withRecordNumMetadata;
            return this;
        }

        @Override
        ContextualTextIO.ReadFiles build() {
            if (this.desiredBundleSizeBytes == null || this.hasMultilineCSVRecords == null || this.withRecordNumMetadata == null) {
                StringBuilder missing = new StringBuilder();
                if (this.desiredBundleSizeBytes == null) {
                    missing.append(" desiredBundleSizeBytes");
                }
                if (this.hasMultilineCSVRecords == null) {
                    missing.append(" hasMultilineCSVRecords");
                }
                if (this.withRecordNumMetadata == null) {
                    missing.append(" withRecordNumMetadata");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ContextualTextIO_ReadFiles(this.desiredBundleSizeBytes, this.delimiter, this.hasMultilineCSVRecords, this.withRecordNumMetadata);
        }
    }
}

