/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.contextualtextio.RecordWithMetadata;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@VisibleForTesting
class ContextualTextIOSource
extends FileBasedSource<Row> {
    byte[] delimiter;
    private boolean hasMultilineCSVRecords;

    protected boolean isSplittable() throws Exception {
        if (this.hasMultilineCSVRecords) {
            return false;
        }
        return super.isSplittable();
    }

    ContextualTextIOSource(ValueProvider<String> fileSpec, EmptyMatchTreatment emptyMatchTreatment, byte[] delimiter, boolean hasMultilineCSVRecords) {
        super(fileSpec, emptyMatchTreatment, 1L);
        this.delimiter = delimiter;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
    }

    private ContextualTextIOSource(MatchResult.Metadata metadata, long start, long end, byte[] delimiter, boolean hasMultilineCSVRecords) {
        super(metadata, 1L, start, end);
        this.delimiter = delimiter;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
    }

    protected FileBasedSource<Row> createForSubrangeOfFile(MatchResult.Metadata metadata, long start, long end) {
        return new ContextualTextIOSource(metadata, start, end, this.delimiter, this.hasMultilineCSVRecords);
    }

    protected FileBasedSource.FileBasedReader<Row> createSingleFileReader(PipelineOptions options) {
        return new MultiLineTextBasedReader(this, this.delimiter, this.hasMultilineCSVRecords);
    }

    public Coder<Row> getOutputCoder() {
        return SchemaCoder.of((Schema)RecordWithMetadata.getSchema());
    }

    @VisibleForTesting
    static class MultiLineTextBasedReader
    extends FileBasedSource.FileBasedReader<Row> {
        public static final int READ_BUFFER_SIZE = 8192;
        private static final ByteString UTF8_BOM = ByteString.copyFrom((byte[])new byte[]{-17, -69, -65});
        private final ByteBuffer readBuffer = ByteBuffer.allocate(8192);
        private ByteString buffer = ByteString.EMPTY;
        private int startOfDelimiterInBuffer;
        private int endOfDelimiterInBuffer;
        private long startOfRecord;
        private volatile long startOfNextRecord;
        private volatile boolean eof;
        private volatile boolean elementIsPresent;
        private @Nullable Row currentValue;
        private @Nullable ReadableByteChannel inChannel;
        private byte @Nullable [] delimiter;
        private boolean hasMultilineCSVRecords;
        private long startingOffset;
        private long totalRecordCount;

        private MultiLineTextBasedReader(ContextualTextIOSource source, byte[] delimiter, boolean hasMultilineCSVRecords) {
            super((FileBasedSource)source);
            this.delimiter = delimiter;
            this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            this.startingOffset = this.getCurrentSource().getStartOffset();
        }

        protected long getCurrentOffset() throws NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        public long getSplitPointsRemaining() {
            if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                return this.isDone() ? 0L : 1L;
            }
            return super.getSplitPointsRemaining();
        }

        public Row getCurrent() throws NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.currentValue;
        }

        protected void startReading(ReadableByteChannel channel) throws IOException {
            this.inChannel = channel;
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset > 0L) {
                Preconditions.checkState((boolean)(channel instanceof SeekableByteChannel), (String)"%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", (Object)ContextualTextIOSource.class.getSimpleName());
                long requiredPosition = startOffset - 1L;
                if (this.delimiter != null && startOffset >= (long)this.delimiter.length) {
                    requiredPosition = startOffset - (long)this.delimiter.length;
                }
                ((SeekableByteChannel)channel).position(requiredPosition);
                this.findDelimiterBounds();
                this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
                this.startOfNextRecord = requiredPosition + (long)this.endOfDelimiterInBuffer;
                this.endOfDelimiterInBuffer = 0;
                this.startOfDelimiterInBuffer = 0;
            }
        }

        private void findDelimiterBounds() throws IOException {
            int bytePositionInBuffer = 0;
            boolean doubleQuoteClosed = true;
            while (true) {
                if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 1)) {
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    break;
                }
                byte currentByte = this.buffer.byteAt(bytePositionInBuffer);
                if (this.hasMultilineCSVRecords) {
                    if (currentByte == 34) {
                        doubleQuoteClosed = !doubleQuoteClosed;
                    }
                } else {
                    doubleQuoteClosed = true;
                }
                if (this.delimiter == null) {
                    if (currentByte == 10) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        if (doubleQuoteClosed) {
                            break;
                        }
                    } else if (currentByte == 13) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        if (this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 2) && (currentByte = this.buffer.byteAt(bytePositionInBuffer + 1)) == 10) {
                            ++this.endOfDelimiterInBuffer;
                        }
                        if (doubleQuoteClosed) {
                            break;
                        }
                    }
                } else {
                    int i = 0;
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    while (i < this.delimiter.length && currentByte == this.delimiter[i]) {
                        if (this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + ++i + 1)) {
                            currentByte = this.buffer.byteAt(bytePositionInBuffer + i);
                            continue;
                        }
                        this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                        break;
                    }
                    if (i == this.delimiter.length) {
                        this.endOfDelimiterInBuffer = bytePositionInBuffer + i;
                        if (doubleQuoteClosed) break;
                    }
                }
                ++bytePositionInBuffer;
            }
        }

        protected boolean readNextRecord() throws IOException {
            this.startOfRecord = this.startOfNextRecord;
            this.findDelimiterBounds();
            if (this.eof && this.buffer.isEmpty()) {
                this.elementIsPresent = false;
                return false;
            }
            this.decodeCurrentElement();
            this.startOfNextRecord = this.startOfRecord + (long)this.endOfDelimiterInBuffer;
            return true;
        }

        private void decodeCurrentElement() throws IOException {
            ByteString dataToDecode = this.buffer.substring(0, this.startOfDelimiterInBuffer);
            if (this.startOfRecord == 0L && dataToDecode.startsWith(UTF8_BOM)) {
                dataToDecode = dataToDecode.substring(UTF8_BOM.size());
            }
            long recordUniqueNum = this.totalRecordCount++;
            this.currentValue = Row.withSchema((Schema)RecordWithMetadata.getSchema()).withFieldValue("recordNumInOffset", (Object)recordUniqueNum).withFieldValue("rangeOffset", (Object)this.startingOffset).withFieldValue("recordOffset", (Object)this.startOfRecord).withFieldValue("resourceId", (Object)this.getCurrentSource().getSingleFileMetadata().resourceId()).withFieldValue("value", (Object)dataToDecode.toStringUtf8()).build();
            this.elementIsPresent = true;
            this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
        }

        private boolean tryToEnsureNumberOfBytesInBuffer(int minCapacity) throws IOException {
            while (this.buffer.size() <= minCapacity && !this.eof) {
                this.eof = this.inChannel.read(this.readBuffer) == -1;
                this.readBuffer.flip();
                this.buffer = this.buffer.concat(ByteString.copyFrom((ByteBuffer)this.readBuffer));
                this.readBuffer.clear();
            }
            return this.buffer.size() >= minCapacity;
        }
    }
}

