/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.contextualtextio.AutoValue_ContextualTextIO_Read;
import org.apache.beam.sdk.io.contextualtextio.AutoValue_ContextualTextIO_ReadFiles;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIOSource;
import org.apache.beam.sdk.io.contextualtextio.RecordWithMetadata;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualTextIO {
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ContextualTextIO.class);

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_ContextualTextIO_Read.Builder().setCompression(Compression.AUTO).setHintMatchesManyFiles(false).setWithRecordNumMetadata(false).setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.DISALLOW)).setHasMultilineCSVRecords(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles readFiles() {
        return new AutoValue_ContextualTextIO_ReadFiles.Builder().setDesiredBundleSizeBytes(0x4000000L).setHasMultilineCSVRecords(false).setWithRecordNumMetadata(false).build();
    }

    private ContextualTextIO() {
    }

    private static class ProcessRecordNumbers
    extends PTransform<PCollection<Row>, PCollection<Row>> {
        private ProcessRecordNumbers() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> records) {
            Trigger currentTrigger = records.getWindowingStrategy().getTrigger();
            ImmutableSet allowedTriggers = ImmutableSet.of((Object)Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow()), (Object)DefaultTrigger.of());
            Preconditions.checkArgument((boolean)allowedTriggers.contains(currentTrigger), (Object)String.format("getWithRecordNumMetadata(true) only supports the default trigger not: %s", currentTrigger));
            PCollection recordsGroupedByFileAndRange = ((PCollection)records.apply("AddFileNameAndRange", (PTransform)ParDo.of((DoFn)new Read.AddFileNameAndRange()))).setCoder((Coder)KvCoder.of((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianLongCoder.of()), (Coder)RowCoder.of((Schema)RecordWithMetadata.getSchema())));
            PCollectionView rangeSizes = (PCollectionView)((PCollection)((PCollection)recordsGroupedByFileAndRange.apply("CountRecordsForEachFileRange", Count.perKey())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.longs(), (TypeDescriptor)TypeDescriptors.longs()))).via((SerializableFunction & Serializable)x -> KV.of((Object)((String)((KV)x.getKey()).getKey()), (Object)KV.of((Object)((Long)((KV)x.getKey()).getValue()), (Object)((Long)x.getValue())))))).apply("SizesAsView", (PTransform)View.asMultimap());
            PCollection singletonPcoll = (PCollection)records.getPipeline().apply("CreateSingletonPcoll", (PTransform)Create.of(Arrays.asList(1)));
            PCollectionView numRecordsBeforeEachRange = (PCollectionView)((PCollection)singletonPcoll.apply("ComputeNumRecordsBeforeRange", (PTransform)ParDo.of((DoFn)new Read.ComputeRecordsBeforeEachRange((PCollectionView<Map<String, Iterable<KV<Long, Long>>>>)rangeSizes)).withSideInputs(new PCollectionView[]{rangeSizes}))).apply("NumRecordsBeforeEachRangeAsView", (PTransform)View.asMultimap());
            return ((PCollection)recordsGroupedByFileAndRange.apply("AssignLineNums", (PTransform)ParDo.of((DoFn)new Read.AssignRecordNums((PCollectionView<Map<String, Iterable<KV<Long, Long>>>>)numRecordsBeforeEachRange)).withSideInputs(new PCollectionView[]{numRecordsBeforeEachRange}))).setRowSchema(RecordWithMetadata.getSchema());
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<Row>> {
        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiter();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getHasMultilineCSVRecords();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getWithRecordNumMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadFiles withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadFiles withRecordNumMetadata() {
            return this.toBuilder().setWithRecordNumMetadata(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withDelimiter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            PCollection rows = (PCollection)input.apply("Read all via FileBasedSource", (PTransform)new ReadAllViaFileBasedSource(this.getDesiredBundleSizeBytes(), (SerializableFunction)new CreateTextSourceFn(this.getDelimiter(), this.getHasMultilineCSVRecords()), (Coder)SchemaCoder.of((Schema)RecordWithMetadata.getSchema())));
            if (!this.getWithRecordNumMetadata()) {
                return rows;
            }
            return (PCollection)rows.apply((PTransform)new ProcessRecordNumbers());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"delimiter", (String)Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        private static class CreateTextSourceFn
        implements SerializableFunction<String, FileBasedSource<Row>> {
            private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter;
            private @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords;

            private CreateTextSourceFn(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords) {
                this.delimiter = delimiter;
                this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            }

            public @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized Row> apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return new ContextualTextIOSource((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input), EmptyMatchTreatment.DISALLOW, this.delimiter, this.hasMultilineCSVRecords);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHasMultilineCSVRecords(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWithRecordNumMetadata(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Row>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getHintMatchesManyFiles();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getWithRecordNumMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getHasMultilineCSVRecords();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiter();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHasMultilineCSVRecords(@UnknownKeyFor @NonNull @Initialized Boolean hasMultilineCSVRecords) {
            return this.toBuilder().setHasMultilineCSVRecords(hasMultilineCSVRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withRecordNumMetadata() {
            return this.toBuilder().setWithRecordNumMetadata(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDelimiter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            Preconditions.checkArgument((delimiter != null ? 1 : 0) != 0, (Object)"delimiter can not be null");
            Preconditions.checkArgument((!Read.isSelfOverlapping(delimiter) ? 1 : 0) != 0, (Object)"delimiter must not self-overlap");
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        static @UnknownKeyFor @NonNull @Initialized boolean isSelfOverlapping(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] s) {
            for (int i = 1; i < s.length - 1; ++i) {
                if (!ByteBuffer.wrap(s, 0, i).equals(ByteBuffer.wrap(s, s.length - i, i))) continue;
                return true;
            }
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (Object)"need to set the filepattern of a ContextualTextIO.Read transform");
            PCollection records = null;
            records = this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles() ? (PCollection)input.apply("Read", (PTransform)org.apache.beam.sdk.io.Read.from(this.getSource())) : (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply("Match All", (PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply("Read Matches", (PTransform)FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply("Via ReadFiles", (PTransform)ContextualTextIO.readFiles().withDelimiter(this.getDelimiter()));
            if (!this.getWithRecordNumMetadata()) {
                return records;
            }
            return (PCollection)records.apply((PTransform)new ProcessRecordNumbers());
        }

        protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized Row> getSource() {
            return CompressedSource.from((FileBasedSource)new ContextualTextIOSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getDelimiter(), this.getHasMultilineCSVRecords())).withCompression(this.getCompression());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"compressionType", (String)this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("File Pattern")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration()).addIfNotNull(DisplayData.item((String)"delimiter", (String)Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records")).addIfNotNull(DisplayData.item((String)"hasMultilineCSVRecords", (Boolean)this.getHasMultilineCSVRecords()).withLabel("Has RFC4180 MultiLineCSV Records"));
        }

        static class AssignRecordNums
        extends DoFn<KV<KV<String, Long>, Row>, Row> {
            @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>>>> numRecordsBeforeEachRange;

            public AssignRecordNums(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>>>> numRecordsBeforeEachRange) {
                this.numRecordsBeforeEachRange = numRecordsBeforeEachRange;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext p) {
                String file = (String)((KV)((KV)p.element()).getKey()).getKey();
                Long offset = (Long)((KV)((KV)p.element()).getKey()).getValue();
                Row record = (Row)((KV)p.element()).getValue();
                Iterator<KV<Long, Long>> numRecordsBeforeEachOffsetInFile = ((Iterable)((Map)p.sideInput(this.numRecordsBeforeEachRange)).get(file)).iterator();
                Long numRecordsLessThanThisOffset = this.getNumRecordsBeforeOffset(offset, numRecordsBeforeEachOffsetInFile);
                Row newLine = Row.fromRow((Row)record).withFieldValue("recordNum", (Object)(record.getInt64("recordNumInOffset") + numRecordsLessThanThisOffset)).build();
                p.output((Object)newLine);
            }

            private @UnknownKeyFor @NonNull @Initialized Long getNumRecordsBeforeOffset(@UnknownKeyFor @NonNull @Initialized Long offset, @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>> numRecordsBeforeEachOffsetInFile) {
                while (numRecordsBeforeEachOffsetInFile.hasNext()) {
                    KV<Long, Long> entry = numRecordsBeforeEachOffsetInFile.next();
                    if (!((Long)entry.getKey()).equals(offset)) continue;
                    return (Long)entry.getValue();
                }
                LOG.error("Unable to compute contextual metadata. Please report a bug in ContextualTextIO");
                return null;
            }
        }

        @VisibleForTesting
        static class ComputeRecordsBeforeEachRange
        extends DoFn<Integer, KV<String, KV<Long, Long>>> {
            private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>>>> rangeSizes;

            public ComputeRecordsBeforeEachRange(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>>>> rangeSizes) {
                this.rangeSizes = rangeSizes;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext p) {
                Map rangeSizesMap = (Map)p.sideInput(this.rangeSizes);
                for (Map.Entry entrySet : rangeSizesMap.entrySet()) {
                    TreeMap sorted = new TreeMap(new FileRangeComparator());
                    ((Iterable)entrySet.getValue()).iterator().forEachRemaining(x -> sorted.put(KV.of((Object)((String)entrySet.getKey()), (Object)((Long)x.getKey())), (Long)x.getValue()));
                    HashMap<String, Long> pastRecords = new HashMap<String, Long>();
                    for (Map.Entry entry : sorted.entrySet()) {
                        Long numRecords = (Long)entry.getValue();
                        KV fileRange = (KV)entry.getKey();
                        String file = (String)fileRange.getKey();
                        Long numRecordsBefore = 0L;
                        if (pastRecords.containsKey(file)) {
                            numRecordsBefore = (Long)pastRecords.get(file);
                        }
                        p.output((Object)KV.of((Object)file, (Object)KV.of((Object)((Long)fileRange.getValue()), (Object)numRecordsBefore)));
                        pastRecords.put(file, numRecordsBefore + numRecords);
                    }
                }
            }

            private static class FileRangeComparator<@UnknownKeyFor K extends @UnknownKeyFor @NonNull @Initialized Comparable<K>, @UnknownKeyFor V extends @UnknownKeyFor @NonNull @Initialized Comparable<V>>
            implements Comparator<KV<K, V>>,
            Serializable {
                private FileRangeComparator() {
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized KV<K, V> a, @UnknownKeyFor @NonNull @Initialized KV<K, V> b) {
                    if (((Comparable)a.getKey()).compareTo((Comparable)b.getKey()) == 0) {
                        return ((Comparable)a.getValue()).compareTo((Comparable)b.getValue());
                    }
                    return ((Comparable)a.getKey()).compareTo((Comparable)b.getKey());
                }
            }
        }

        @VisibleForTesting
        static class AddFileNameAndRange
        extends DoFn<Row, KV<KV<String, Long>, Row>> {
            AddFileNameAndRange() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row record, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized Row>> out) {
                out.output((Object)KV.of((Object)KV.of((Object)((ResourceId)record.getLogicalTypeValue("resourceId", ResourceId.class)).toString(), (Object)record.getInt64("rangeOffset")), (Object)record));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHintMatchesManyFiles(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWithRecordNumMetadata(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHasMultilineCSVRecords(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

