/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.contextualtextio.RecordWithMetadata;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
class ContextualTextIOSource
extends FileBasedSource<Row> {
    @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter;
    private @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords;

    protected @UnknownKeyFor @NonNull @Initialized boolean isSplittable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.hasMultilineCSVRecords) {
            return false;
        }
        return super.isSplittable();
    }

    ContextualTextIOSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords) {
        super(fileSpec, emptyMatchTreatment, 1L);
        this.delimiter = delimiter;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
    }

    private ContextualTextIOSource(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords) {
        super(metadata, 1L, start, end);
        this.delimiter = delimiter;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
    }

    protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized Row> createForSubrangeOfFile(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return new ContextualTextIOSource(metadata, start, end, this.delimiter, this.hasMultilineCSVRecords);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<@UnknownKeyFor @NonNull @Initialized Row> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new MultiLineTextBasedReader(this, this.delimiter, this.hasMultilineCSVRecords);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> getOutputCoder() {
        return SchemaCoder.of((Schema)RecordWithMetadata.getSchema());
    }

    @VisibleForTesting
    static class MultiLineTextBasedReader
    extends FileBasedSource.FileBasedReader<Row> {
        public static final @UnknownKeyFor @NonNull @Initialized int READ_BUFFER_SIZE = 8192;
        private static final @UnknownKeyFor @NonNull @Initialized ByteString UTF8_BOM = ByteString.copyFrom((byte[])new byte[]{-17, -69, -65});
        private final @UnknownKeyFor @NonNull @Initialized ByteBuffer readBuffer = ByteBuffer.allocate(8192);
        private @UnknownKeyFor @NonNull @Initialized ByteString buffer = ByteString.EMPTY;
        private @UnknownKeyFor @NonNull @Initialized int startOfDelimiterInBuffer;
        private @UnknownKeyFor @NonNull @Initialized int endOfDelimiterInBuffer;
        private @UnknownKeyFor @NonNull @Initialized long startOfRecord;
        private volatile @UnknownKeyFor @NonNull @Initialized long startOfNextRecord;
        private volatile @UnknownKeyFor @NonNull @Initialized boolean eof;
        private volatile @UnknownKeyFor @NonNull @Initialized boolean elementIsPresent;
        private @Nullable @UnknownKeyFor @Initialized Row currentValue;
        private @Nullable @UnknownKeyFor @Initialized ReadableByteChannel inChannel;
        private @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] delimiter;
        private @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords;
        private @UnknownKeyFor @NonNull @Initialized long startingOffset;
        private @UnknownKeyFor @NonNull @Initialized long totalRecordCount;

        private MultiLineTextBasedReader(@UnknownKeyFor @NonNull @Initialized ContextualTextIOSource source, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized boolean hasMultilineCSVRecords) {
            super((FileBasedSource)source);
            this.delimiter = delimiter;
            this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            this.startingOffset = this.getCurrentSource().getStartOffset();
        }

        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        public @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                return this.isDone() ? 0L : 1L;
            }
            return super.getSplitPointsRemaining();
        }

        public @UnknownKeyFor @NonNull @Initialized Row getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.elementIsPresent) {
                throw new NoSuchElementException();
            }
            return this.currentValue;
        }

        protected void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.inChannel = channel;
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset > 0L) {
                Preconditions.checkState((boolean)(channel instanceof SeekableByteChannel), (String)"%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", (Object)ContextualTextIOSource.class.getSimpleName());
                long requiredPosition = startOffset - 1L;
                if (this.delimiter != null && startOffset >= (long)this.delimiter.length) {
                    requiredPosition = startOffset - (long)this.delimiter.length;
                }
                ((SeekableByteChannel)channel).position(requiredPosition);
                this.findDelimiterBounds();
                this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
                this.startOfNextRecord = requiredPosition + (long)this.endOfDelimiterInBuffer;
                this.endOfDelimiterInBuffer = 0;
                this.startOfDelimiterInBuffer = 0;
            }
        }

        private void findDelimiterBounds() throws @UnknownKeyFor @NonNull @Initialized IOException {
            int bytePositionInBuffer = 0;
            boolean doubleQuoteClosed = true;
            while (true) {
                if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 1)) {
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    break;
                }
                byte currentByte = this.buffer.byteAt(bytePositionInBuffer);
                if (this.hasMultilineCSVRecords) {
                    if (currentByte == 34) {
                        doubleQuoteClosed = !doubleQuoteClosed;
                    }
                } else {
                    doubleQuoteClosed = true;
                }
                if (this.delimiter == null) {
                    if (currentByte == 10) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        if (doubleQuoteClosed) {
                            break;
                        }
                    } else if (currentByte == 13) {
                        this.startOfDelimiterInBuffer = bytePositionInBuffer;
                        this.endOfDelimiterInBuffer = this.startOfDelimiterInBuffer + 1;
                        if (this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 2) && (currentByte = this.buffer.byteAt(bytePositionInBuffer + 1)) == 10) {
                            ++this.endOfDelimiterInBuffer;
                        }
                        if (doubleQuoteClosed) {
                            break;
                        }
                    }
                } else {
                    int i = 0;
                    this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                    while (i < this.delimiter.length && currentByte == this.delimiter[i]) {
                        if (this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + ++i + 1)) {
                            currentByte = this.buffer.byteAt(bytePositionInBuffer + i);
                            continue;
                        }
                        this.startOfDelimiterInBuffer = this.endOfDelimiterInBuffer = bytePositionInBuffer;
                        break;
                    }
                    if (i == this.delimiter.length) {
                        this.endOfDelimiterInBuffer = bytePositionInBuffer + i;
                        if (doubleQuoteClosed) break;
                    }
                }
                ++bytePositionInBuffer;
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.startOfRecord = this.startOfNextRecord;
            this.findDelimiterBounds();
            if (this.eof && this.buffer.isEmpty()) {
                this.elementIsPresent = false;
                return false;
            }
            this.decodeCurrentElement();
            this.startOfNextRecord = this.startOfRecord + (long)this.endOfDelimiterInBuffer;
            return true;
        }

        private void decodeCurrentElement() throws @UnknownKeyFor @NonNull @Initialized IOException {
            ByteString dataToDecode = this.buffer.substring(0, this.startOfDelimiterInBuffer);
            if (this.startOfRecord == 0L && dataToDecode.startsWith(UTF8_BOM)) {
                dataToDecode = dataToDecode.substring(UTF8_BOM.size());
            }
            long recordUniqueNum = this.totalRecordCount++;
            this.currentValue = Row.withSchema((Schema)RecordWithMetadata.getSchema()).withFieldValue("recordNumInOffset", (Object)recordUniqueNum).withFieldValue("rangeOffset", (Object)this.startingOffset).withFieldValue("recordOffset", (Object)this.startOfRecord).withFieldValue("resourceId", (Object)this.getCurrentSource().getSingleFileMetadata().resourceId()).withFieldValue("value", (Object)dataToDecode.toStringUtf8()).build();
            this.elementIsPresent = true;
            this.buffer = this.buffer.substring(this.endOfDelimiterInBuffer);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean tryToEnsureNumberOfBytesInBuffer(@UnknownKeyFor @NonNull @Initialized int minCapacity) throws @UnknownKeyFor @NonNull @Initialized IOException {
            while (this.buffer.size() <= minCapacity && !this.eof) {
                this.eof = this.inChannel.read(this.readBuffer) == -1;
                this.readBuffer.flip();
                this.buffer = this.buffer.concat(ByteString.copyFrom((ByteBuffer)this.readBuffer));
                this.readBuffer.clear();
            }
            return this.buffer.size() >= minCapacity;
        }
    }
}

