/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RecordWithMetadata {
    public static final @UnknownKeyFor @NonNull @Initialized String VALUE = "value";
    public static final @UnknownKeyFor @NonNull @Initialized String RESOURCE_ID = "resourceId";
    public static final @UnknownKeyFor @NonNull @Initialized String RECORD_NUM = "recordNum";
    public static final @UnknownKeyFor @NonNull @Initialized String RANGE_OFFSET = "rangeOffset";
    public static final @UnknownKeyFor @NonNull @Initialized String RECORD_NUM_IN_OFFSET = "recordNumInOffset";
    public static final @UnknownKeyFor @NonNull @Initialized String RECORD_OFFSET = "recordOffset";

    public static @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return Schema.builder().addStringField(VALUE).addLogicalTypeField(RESOURCE_ID, (Schema.LogicalType)new ResourceIdRow()).addNullableField(RECORD_NUM, Schema.FieldType.INT64).addInt64Field(RECORD_OFFSET).addInt64Field(RECORD_NUM_IN_OFFSET).addInt64Field(RANGE_OFFSET).build();
    }

    private static class ResourceIdRow
    implements Schema.LogicalType<ResourceId, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addStringField("resource").addBooleanField("is_directory").build();

        private ResourceIdRow() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized Schema.FieldType getArgumentType() {
            return Schema.FieldType.STRING;
        }

        public @UnknownKeyFor @NonNull @Initialized String getArgument() {
            return "";
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
            return "beam:logical_type:resource_id:v1";
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
            return Schema.FieldType.row((Schema)this.schema);
        }

        public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId) {
            return Row.withSchema((Schema)this.schema).withFieldValue("resource", (Object)resourceId.toString()).withFieldValue("is_directory", (Object)resourceId.isDirectory()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId toInputType(@UnknownKeyFor @NonNull @Initialized Row base) {
            Preconditions.checkNotNull((Object)base.getString("resource"));
            Preconditions.checkNotNull((Object)base.getBoolean("is_directory"));
            return FileSystems.matchNewResource((String)base.getString("resource"), (boolean)base.getBoolean("is_directory"));
        }
    }
}

