/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;

public class PubsubJsonClient
extends PubsubClient {
    public static final PubsubClient.PubsubClientFactory FACTORY = new PubsubJsonClientFactory();
    @Nullable
    private final String timestampAttribute;
    @Nullable
    private final String idAttribute;
    private Pubsub pubsub;

    @VisibleForTesting
    PubsubJsonClient(@Nullable String timestampAttribute, @Nullable String idAttribute, Pubsub pubsub) {
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.pubsub = pubsub;
    }

    @Override
    public void close() {
    }

    @Override
    public int publish(PubsubClient.TopicPath topic, List<PubsubClient.OutgoingMessage> outgoingMessages) throws IOException {
        ArrayList<PubsubMessage> pubsubMessages = new ArrayList<PubsubMessage>(outgoingMessages.size());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            PubsubMessage pubsubMessage = new PubsubMessage().encodeData(outgoingMessage.elementBytes);
            pubsubMessage.setAttributes(this.getMessageAttributes(outgoingMessage));
            pubsubMessages.add(pubsubMessage);
        }
        PublishRequest request = new PublishRequest().setMessages(pubsubMessages);
        PublishResponse response = (PublishResponse)this.pubsub.projects().topics().publish(topic.getPath(), request).execute();
        return response.getMessageIds().size();
    }

    private Map<String, String> getMessageAttributes(PubsubClient.OutgoingMessage outgoingMessage) {
        TreeMap<Object, Object> attributes = null;
        attributes = outgoingMessage.attributes == null ? new TreeMap() : new TreeMap<String, String>(outgoingMessage.attributes);
        if (this.timestampAttribute != null) {
            attributes.put(this.timestampAttribute, String.valueOf(outgoingMessage.timestampMsSinceEpoch));
        }
        if (this.idAttribute != null && !Strings.isNullOrEmpty((String)outgoingMessage.recordId)) {
            attributes.put(this.idAttribute, outgoingMessage.recordId);
        }
        return attributes;
    }

    @Override
    public List<PubsubClient.IncomingMessage> pull(long requestTimeMsSinceEpoch, PubsubClient.SubscriptionPath subscription, int batchSize, boolean returnImmediately) throws IOException {
        PullRequest request = new PullRequest().setReturnImmediately(Boolean.valueOf(returnImmediately)).setMaxMessages(Integer.valueOf(batchSize));
        PullResponse response = (PullResponse)this.pubsub.projects().subscriptions().pull(subscription.getPath(), request).execute();
        if (response.getReceivedMessages() == null || response.getReceivedMessages().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessages().size());
        for (ReceivedMessage message : response.getReceivedMessages()) {
            PubsubMessage pubsubMessage = message.getMessage();
            Map attributes = pubsubMessage.getAttributes();
            byte[] elementBytes = pubsubMessage.decodeData();
            if (elementBytes == null) {
                elementBytes = new byte[]{};
            }
            long timestampMsSinceEpoch = PubsubJsonClient.extractTimestamp(this.timestampAttribute, message.getMessage().getPublishTime(), attributes);
            String ackId = message.getAckId();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)ackId) ? 1 : 0) != 0);
            String recordId = null;
            if (this.idAttribute != null && attributes != null) {
                recordId = (String)attributes.get(this.idAttribute);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            incomingMessages.add(new PubsubClient.IncomingMessage(elementBytes, attributes, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(PubsubClient.SubscriptionPath subscription, List<String> ackIds) throws IOException {
        AcknowledgeRequest request = new AcknowledgeRequest().setAckIds(ackIds);
        this.pubsub.projects().subscriptions().acknowledge(subscription.getPath(), request).execute();
    }

    @Override
    public void modifyAckDeadline(PubsubClient.SubscriptionPath subscription, List<String> ackIds, int deadlineSeconds) throws IOException {
        ModifyAckDeadlineRequest request = new ModifyAckDeadlineRequest().setAckIds(ackIds).setAckDeadlineSeconds(Integer.valueOf(deadlineSeconds));
        this.pubsub.projects().subscriptions().modifyAckDeadline(subscription.getPath(), request).execute();
    }

    @Override
    public void createTopic(PubsubClient.TopicPath topic) throws IOException {
        this.pubsub.projects().topics().create(topic.getPath(), new Topic()).execute();
    }

    @Override
    public void deleteTopic(PubsubClient.TopicPath topic) throws IOException {
        this.pubsub.projects().topics().delete(topic.getPath()).execute();
    }

    @Override
    public List<PubsubClient.TopicPath> listTopics(PubsubClient.ProjectPath project) throws IOException {
        Pubsub.Projects.Topics.List request = this.pubsub.projects().topics().list(project.getPath());
        ListTopicsResponse response = (ListTopicsResponse)request.execute();
        if (response.getTopics() == null || response.getTopics().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopics().size());
        while (true) {
            for (Topic topic : response.getTopics()) {
                topics.add(PubsubJsonClient.topicPathFromPath(topic.getName()));
            }
            if (Strings.isNullOrEmpty((String)response.getNextPageToken())) break;
            request.setPageToken(response.getNextPageToken());
            response = (ListTopicsResponse)request.execute();
        }
        return topics;
    }

    @Override
    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
        Subscription request = new Subscription().setTopic(topic.getPath()).setAckDeadlineSeconds(Integer.valueOf(ackDeadlineSeconds));
        this.pubsub.projects().subscriptions().create(subscription.getPath(), request).execute();
    }

    @Override
    public void deleteSubscription(PubsubClient.SubscriptionPath subscription) throws IOException {
        this.pubsub.projects().subscriptions().delete(subscription.getPath()).execute();
    }

    @Override
    public List<PubsubClient.SubscriptionPath> listSubscriptions(PubsubClient.ProjectPath project, PubsubClient.TopicPath topic) throws IOException {
        Pubsub.Projects.Subscriptions.List request = this.pubsub.projects().subscriptions().list(project.getPath());
        ListSubscriptionsResponse response = (ListSubscriptionsResponse)request.execute();
        if (response.getSubscriptions() == null || response.getSubscriptions().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptions().size());
        while (true) {
            for (Subscription subscription : response.getSubscriptions()) {
                if (!subscription.getTopic().equals(topic.getPath())) continue;
                subscriptions.add(PubsubJsonClient.subscriptionPathFromPath(subscription.getName()));
            }
            if (Strings.isNullOrEmpty((String)response.getNextPageToken())) break;
            request.setPageToken(response.getNextPageToken());
            response = (ListSubscriptionsResponse)request.execute();
        }
        return subscriptions;
    }

    @Override
    public int ackDeadlineSeconds(PubsubClient.SubscriptionPath subscription) throws IOException {
        Subscription response = (Subscription)this.pubsub.projects().subscriptions().get(subscription.getPath()).execute();
        return response.getAckDeadlineSeconds();
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    private static class PubsubJsonClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubJsonClientFactory() {
        }

        private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
            if (credential == null) {
                return httpRequestInitializer;
            }
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
        }

        @Override
        public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options) throws IOException {
            Pubsub pubsub = new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), PubsubJsonClientFactory.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
            return new PubsubJsonClient(timestampAttribute, idAttribute, pubsub);
        }

        @Override
        public String getKind() {
            return "Json";
        }
    }
}

