/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class BigQueryTableSource<T>
extends BigQuerySourceBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableSource.class);
    private final ValueProvider<String> jsonTable;
    private final AtomicReference<Long> tableSizeBytes;

    static <T> BigQueryTableSource<T> create(String stepUuid, ValueProvider<TableReference> table, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        return new BigQueryTableSource<T>(stepUuid, table, bqServices, coder, parseFn);
    }

    private BigQueryTableSource(String stepUuid, ValueProvider<TableReference> table, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        super(stepUuid, bqServices, coder, parseFn);
        this.jsonTable = ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(table, (Object)"table")), (SerializableFunction)new BigQueryHelpers.TableRefToJson());
        this.tableSizeBytes = new AtomicReference();
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException {
        TableReference tableReference = (TableReference)BigQueryIO.JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
        return this.setDefaultProjectIfAbsent(bqOptions, tableReference);
    }

    private TableReference setDefaultProjectIfAbsent(BigQueryOptions bqOptions, TableReference tableReference) {
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)bqOptions.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReference.class.getSimpleName());
            LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
            tableReference.setProjectId(bqOptions.getProject());
        }
        return tableReference;
    }

    public synchronized long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        if (this.tableSizeBytes.get() == null) {
            TableReference table = this.setDefaultProjectIfAbsent((BigQueryOptions)options.as(BigQueryOptions.class), (TableReference)BigQueryIO.JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class));
            Long numBytes = this.bqServices.getDatasetService((BigQueryOptions)options.as(BigQueryOptions.class)).getTable(table).getNumBytes();
            this.tableSizeBytes.compareAndSet(null, numBytes);
        }
        return this.tableSizeBytes.get();
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", this.jsonTable));
    }
}

