/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class PubsubMessage {
    private byte[] message;
    @Nullable
    private Map<String, String> attributes;
    @Nullable
    private String messageId;

    public PubsubMessage(byte[] payload, @Nullable Map<String, String> attributes) {
        this.message = payload;
        this.attributes = attributes;
        this.messageId = null;
    }

    public PubsubMessage(byte[] payload, @Nullable Map<String, String> attributes, @Nullable String messageId) {
        this.message = payload;
        this.attributes = attributes;
        this.messageId = messageId;
    }

    public byte[] getPayload() {
        return this.message;
    }

    @Nullable
    public String getAttribute(String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return this.attributes.get(attribute);
    }

    @Nullable
    public Map<String, String> getAttributeMap() {
        return this.attributes;
    }

    @Nullable
    public String getMessageId() {
        return this.messageId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.message).add("attributes", this.attributes).add("messageId", (Object)this.messageId).toString();
    }
}

