/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

class OffsetByteRangeTracker
extends RestrictionTracker<OffsetRange, OffsetByteProgress>
implements RestrictionTracker.HasProgress {
    private final TopicBacklogReader backlogReader;
    private final Duration minTrackingTime;
    private final long minBytesReceived;
    private final Stopwatch stopwatch;
    private OffsetRange range;
    @Nullable
    private Long lastClaimed;
    private long byteCount = 0L;

    public OffsetByteRangeTracker(OffsetRange range, TopicBacklogReader backlogReader, Stopwatch stopwatch, Duration minTrackingTime, long minBytesReceived) {
        Preconditions.checkArgument((range.getTo() == Long.MAX_VALUE ? 1 : 0) != 0);
        this.backlogReader = backlogReader;
        this.minTrackingTime = minTrackingTime;
        this.minBytesReceived = minBytesReceived;
        this.stopwatch = stopwatch.reset().start();
        this.range = range;
    }

    public void finalize() {
        this.backlogReader.close();
    }

    public RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    public boolean tryClaim(OffsetByteProgress position) {
        long toClaim = position.lastOffset().value();
        Preconditions.checkArgument((this.lastClaimed == null || toClaim > this.lastClaimed ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (long)position.lastOffset().value(), (Object)this.lastClaimed);
        Preconditions.checkArgument((toClaim >= this.range.getFrom() ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (long)toClaim, (Object)this.range);
        if (this.range.getTo() != Long.MAX_VALUE) {
            boolean isRangeEmpty = this.range.getTo() == this.range.getFrom();
            boolean isValidClosedRange = this.nextOffset() == this.range.getTo();
            Preconditions.checkState((isRangeEmpty || isValidClosedRange ? 1 : 0) != 0, (Object)"Violated class precondition: offset range improperly split. Please report a beam bug.");
            return false;
        }
        this.lastClaimed = toClaim;
        this.byteCount += position.batchBytes();
        return true;
    }

    public OffsetRange currentRestriction() {
        return this.range;
    }

    private long nextOffset() {
        Preconditions.checkState((this.lastClaimed == null || this.lastClaimed < Long.MAX_VALUE ? 1 : 0) != 0);
        return this.lastClaimed == null ? this.currentRestriction().getFrom() : this.lastClaimed + 1L;
    }

    private boolean receivedEnough() {
        Duration duration = Duration.millis((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (duration.isLongerThan((ReadableDuration)this.minTrackingTime)) {
            return true;
        }
        return this.byteCount >= this.minBytesReceived;
    }

    @Nullable
    public SplitResult<OffsetRange> trySplit(double fractionOfRemainder) {
        if (this.range.getTo() != Long.MAX_VALUE) {
            return null;
        }
        if (!this.receivedEnough()) {
            return null;
        }
        this.range = new OffsetRange(this.currentRestriction().getFrom(), this.nextOffset());
        return SplitResult.of((Object)this.range, (Object)new OffsetRange(this.nextOffset(), Long.MAX_VALUE));
    }

    public void checkDone() throws IllegalStateException {
        if (this.range.getFrom() == this.range.getTo()) {
            return;
        }
        Preconditions.checkState((this.lastClaimed != null ? 1 : 0) != 0, (String)"Last attempted offset should not be null. No work was claimed in non-empty range %s.", (Object)this.range);
        long lastClaimedNotNull = (Long)Preconditions.checkNotNull((Object)this.lastClaimed);
        Preconditions.checkState((lastClaimedNotNull >= this.range.getTo() - 1L ? 1 : 0) != 0, (String)"Last attempted offset was %s in range %s, claiming work in [%s, %s) was not attempted", (Object)lastClaimedNotNull, (Object)this.range, (Object)(lastClaimedNotNull + 1L), (Object)this.range.getTo());
    }

    public RestrictionTracker.Progress getProgress() {
        ComputeMessageStatsResponse stats = this.backlogReader.computeMessageStats(Offset.of((long)this.nextOffset()));
        return RestrictionTracker.Progress.from((double)this.byteCount, (double)stats.getMessageBytes());
    }
}

