/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

@Description(value="Options that are used to configure Google BigQuery. See https://cloud.google.com/bigquery/what-is-bigquery for details on BigQuery.")
public interface BigQueryOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
StreamingOptions {
    @Description(value="Temporary dataset for BigQuery table operations. Supported values are \"bigquery.googleapis.com/{dataset}\"")
    @Default.String(value="bigquery.googleapis.com/cloud_dataflow")
    public String getTempDatasetId();

    public void setTempDatasetId(String var1);

    @Description(value="Timeout for HTTP requests to BigQuery service in milliseconds. Set to 0 to disable.")
    @Default.Integer(value=900000)
    public Integer getHTTPWriteTimeout();

    public void setHTTPWriteTimeout(Integer var1);

    @Description(value="If specified, the given number of maximum concurrent threads will be used to insert rows from one bundle to BigQuery service with streaming insert API.")
    @Default.Integer(value=3)
    public Integer getInsertBundleParallelism();

    public void setInsertBundleParallelism(Integer var1);

    @Description(value="The number of keys used per table when doing streaming inserts to BigQuery.")
    @Default.Integer(value=50)
    public Integer getNumStreamingKeys();

    public void setNumStreamingKeys(Integer var1);

    @Description(value="The maximum number of rows to batch in a single streaming insert to BigQuery.")
    @Default.Long(value=500L)
    public Long getMaxStreamingRowsToBatch();

    public void setMaxStreamingRowsToBatch(Long var1);

    @Description(value="The maximum byte size of a single streaming insert to BigQuery.")
    @Default.Long(value=65536L)
    public Long getMaxStreamingBatchSize();

    public void setMaxStreamingBatchSize(Long var1);

    @Description(value="The minimum duration in seconds between streaming API statistics logging. The interval might be longer than the specified value due to each bundle processing time.")
    @Default.Integer(value=180)
    public Integer getBqStreamingApiLoggingFrequencySec();

    public void setBqStreamingApiLoggingFrequencySec(Integer var1);

    @Description(value="If set, then BigQueryIO.Write will default to using the Storage Write API.")
    @Default.Boolean(value=false)
    public Boolean getUseStorageWriteApi();

    public void setUseStorageWriteApi(Boolean var1);

    @Description(value="If set, then BigQueryIO.Write will default to using this number of Storage Write API streams.")
    @Default.Integer(value=0)
    public Integer getNumStorageWriteApiStreams();

    public void setNumStorageWriteApiStreams(Integer var1);

    @Description(value="If set, then BigQueryIO.Write will default to triggering the Storage Write API writes this often.")
    public Integer getStorageWriteApiTriggeringFrequencySec();

    public void setStorageWriteApiTriggeringFrequencySec(Integer var1);

    @Description(value="When auto-sharding is used, the maximum duration in milliseconds the input records are allowed to be buffered before being written to BigQuery.")
    @Default.Integer(value=0)
    public Integer getMaxBufferingDurationMilliSec();

    public void setMaxBufferingDurationMilliSec(Integer var1);

    @Description(value="If specified, it will override the default (GcpOptions#getProject()) project id.")
    public String getBigQueryProject();

    public void setBigQueryProject(String var1);
}

