/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFn;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class BigtableRowToBeamRowFlat
extends PTransform<PCollection<Row>, PCollection<org.apache.beam.sdk.values.Row>> {
    private final Schema schema;
    private final Map<String, Set<String>> columnsMapping;

    public BigtableRowToBeamRowFlat(Schema schema, Map<String, Set<String>> columnsMapping) {
        this.schema = schema;
        this.columnsMapping = columnsMapping;
    }

    public PCollection<org.apache.beam.sdk.values.Row> expand(PCollection<Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBeamRowFn(this.schema, this.columnsMapping)));
    }

    private static class ToBeamRowFn
    extends BigtableRowToBeamRowFn {
        private final Map<String, Set<String>> columnsMapping;

        public ToBeamRowFn(Schema schema, Map<String, Set<String>> columnsMapping) {
            super(schema);
            this.columnsMapping = columnsMapping;
        }

        public org.apache.beam.sdk.values.Row apply(Row bigtableRow) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)this.schema).withFieldValue("key", (Object)bigtableRow.getKey().toStringUtf8());
            bigtableRow.getFamiliesList().stream().filter(family -> this.columnsMapping.containsKey(family.getName())).forEach(family -> this.setFamily(rowBuilder, (Family)family));
            return rowBuilder.build();
        }

        private void setFamily(Row.FieldValueBuilder rowBuilder, Family family) {
            Set<String> columns = this.columnsMapping.get(family.getName());
            if (columns == null) {
                throw new NullPointerException("Null column list at family " + family.getName());
            }
            family.getColumnsList().stream().filter(column -> columns.contains(column.getQualifier().toStringUtf8())).forEach(column -> this.setColumn(rowBuilder, (Column)column));
        }

        private void setColumn(Row.FieldValueBuilder rowBuilder, Column column) {
            String columnName = column.getQualifier().toStringUtf8();
            Schema.TypeName type = this.schema.getField(columnName).getType().getTypeName();
            rowBuilder.withFieldValue(columnName, this.getCellValue(this.getLastCell(column.getCellsList()), type));
        }
    }
}

