/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedBacklogReaderFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.joda.time.Duration;
import org.joda.time.Instant;

class PerSubscriptionPartitionSdf
extends DoFn<SubscriptionPartition, SequencedMessage> {
    private final Duration maxSleepTime;
    private final ManagedBacklogReaderFactory backlogReaderFactory;
    private final SubscriptionPartitionProcessorFactory processorFactory;
    private final SerializableFunction<SubscriptionPartition, InitialOffsetReader> offsetReaderFactory;
    private final SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress> trackerFactory;
    private final SerializableFunction<SubscriptionPartition, BlockingCommitter> committerFactory;

    PerSubscriptionPartitionSdf(Duration maxSleepTime, ManagedBacklogReaderFactory backlogReaderFactory, SerializableFunction<SubscriptionPartition, InitialOffsetReader> offsetReaderFactory, SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress> trackerFactory, SubscriptionPartitionProcessorFactory processorFactory, SerializableFunction<SubscriptionPartition, BlockingCommitter> committerFactory) {
        this.maxSleepTime = maxSleepTime;
        this.backlogReaderFactory = backlogReaderFactory;
        this.processorFactory = processorFactory;
        this.offsetReaderFactory = offsetReaderFactory;
        this.trackerFactory = trackerFactory;
        this.committerFactory = committerFactory;
    }

    @DoFn.Teardown
    public void teardown() {
        this.backlogReaderFactory.close();
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public Instant getInitialWatermarkState() {
        return Instant.EPOCH;
    }

    @DoFn.NewWatermarkEstimator
    public WatermarkEstimators.MonotonicallyIncreasing newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant state) {
        return new WatermarkEstimators.MonotonicallyIncreasing(state);
    }

    @DoFn.ProcessElement
    public DoFn.ProcessContinuation processElement(RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker, @DoFn.Element SubscriptionPartition subscriptionPartition, DoFn.OutputReceiver<SequencedMessage> receiver) throws Exception {
        SubscriptionPartitionProcessor processor = this.processorFactory.newProcessor(subscriptionPartition, tracker, receiver);
        DoFn.ProcessContinuation result = processor.runFor(this.maxSleepTime);
        processor.lastClaimed().ifPresent(lastClaimedOffset -> {
            Offset commitOffset = Offset.of((long)(lastClaimedOffset.value() + 1L));
            try {
                ((BlockingCommitter)this.committerFactory.apply((Object)subscriptionPartition)).commitOffset(commitOffset);
            }
            catch (Exception e) {
                throw ExtractStatus.toCanonical((Throwable)e).underlying;
            }
        });
        return result;
    }

    @DoFn.GetInitialRestriction
    public OffsetByteRange getInitialRestriction(@DoFn.Element SubscriptionPartition subscriptionPartition) {
        try (InitialOffsetReader reader = (InitialOffsetReader)this.offsetReaderFactory.apply((Object)subscriptionPartition);){
            Offset offset = reader.read();
            OffsetByteRange offsetByteRange = OffsetByteRange.of(new OffsetRange(offset.value(), Long.MAX_VALUE));
            return offsetByteRange;
        }
    }

    @DoFn.NewTracker
    public TrackerWithProgress newTracker(@DoFn.Element SubscriptionPartition subscriptionPartition, @DoFn.Restriction OffsetByteRange range) {
        return (TrackerWithProgress)((Object)this.trackerFactory.apply((Object)this.backlogReaderFactory.newReader(subscriptionPartition), (Object)range));
    }

    @DoFn.GetSize
    public double getSize(@DoFn.Element SubscriptionPartition subscriptionPartition, @DoFn.Restriction OffsetByteRange restriction) {
        if (restriction.getRange().getTo() != Long.MAX_VALUE) {
            return restriction.getByteCount();
        }
        return this.newTracker(subscriptionPartition, restriction).getProgress().getWorkRemaining();
    }
}

