/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;

class PublisherAssembler {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private final PublisherOptions options;

    PublisherAssembler(PublisherOptions options) {
        this.options = options;
    }

    private AdminClient newAdminClient() throws ApiException {
        try {
            return AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setServiceClient(AdminServiceClient.create((AdminServiceSettings)((AdminServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.topicPath().location().extractRegion(), (ClientSettings.Builder)AdminServiceSettings.newBuilder())))).setRegion(this.options.topicPath().location().extractRegion()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private PublisherServiceClient newServiceClient(Partition partition) {
        PublisherServiceSettings.Builder settingsBuilder = PublisherServiceSettings.newBuilder();
        settingsBuilder = (PublisherServiceSettings.Builder)ServiceClients.addDefaultMetadata((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((TopicPath)this.options.topicPath(), (Partition)partition), (ClientSettings.Builder)settingsBuilder);
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((PublisherServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.topicPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Publisher<MessageMetadata> newPublisher() throws ApiException {
        return PartitionCountWatchingPublisherSettings.newBuilder().setTopic(this.options.topicPath()).setPublisherFactory(partition -> SinglePartitionPublisherBuilder.newBuilder().setTopic(this.options.topicPath()).setPartition(partition).setServiceClient(this.newServiceClient(partition)).setBatchingSettings(PublisherSettings.DEFAULT_BATCHING_SETTINGS).build()).setAdminClient(this.newAdminClient()).build().instantiate();
    }
}

