/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Value;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class PartitionMetadataDao {
    private static final Tracer TRACER = Tracing.getTracer();
    private final String metadataTableName;
    private final DatabaseClient databaseClient;

    PartitionMetadataDao(String metadataTableName, DatabaseClient databaseClient) {
        this.metadataTableName = metadataTableName;
        this.databaseClient = databaseClient;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Struct getPartition(String partitionToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ResultSet getPartitionsInState(PartitionMetadata.State state) {
        try (Scope scope = TRACER.spanBuilder("getPartitionsInState").setRecordEvents(true).startScopedSpan();){
            Statement statement = ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE State = @state ORDER BY " + "StartTimestamp" + " ASC")).bind("state").to(state.toString())).build();
            ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);
            return resultSet;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Timestamp getUnfinishedMinWatermark() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Timestamp insert(PartitionMetadata row) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.insert(row));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToScheduled(String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToScheduled(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToRunning(String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToRunning(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToFinished(String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToFinished(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public void updateWatermark(String partitionToken, Timestamp watermark) {
        this.runInTransaction(transaction -> transaction.updateWatermark(partitionToken, watermark));
    }

    public <T> TransactionResult<T> runInTransaction(Function<InTransactionContext, T> callable) {
        TransactionRunner readWriteTransaction = this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
        Object result = readWriteTransaction.run(transaction -> {
            InTransactionContext transactionContext = new InTransactionContext(this.metadataTableName, transaction);
            return callable.apply(transactionContext);
        });
        return new TransactionResult<Object>(result, readWriteTransaction.getCommitTimestamp());
    }

    public static class TransactionResult<T> {
        @Nullable
        private final T result;
        private final Timestamp commitTimestamp;

        public TransactionResult(@Nullable T result, Timestamp commitTimestamp) {
            this.result = result;
            this.commitTimestamp = commitTimestamp;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        public Timestamp getCommitTimestamp() {
            return this.commitTimestamp;
        }

        public String toString() {
            return "CommitResponse{result=" + this.result + ", commitTimestamp=" + this.commitTimestamp + '}';
        }
    }

    public static class InTransactionContext {
        private static final Tracer TRACER = Tracing.getTracer();
        private final String metadataTableName;
        private final TransactionContext transaction;
        private final Map<PartitionMetadata.State, String> stateToTimestampColumn;

        public InTransactionContext(String metadataTableName, TransactionContext transaction) {
            this.metadataTableName = metadataTableName;
            this.transaction = transaction;
            this.stateToTimestampColumn = new HashMap<PartitionMetadata.State, String>();
            this.stateToTimestampColumn.put(PartitionMetadata.State.CREATED, "CreatedAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.SCHEDULED, "ScheduledAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.RUNNING, "RunningAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.FINISHED, "FinishedAt");
        }

        public Void insert(PartitionMetadata row) {
            try (Scope scope = TRACER.spanBuilder("insert").setRecordEvents(true).startScopedSpan();){
                TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)row.getPartitionToken()));
                this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createInsertMetadataMutationFrom(row)));
                Void void_ = null;
                return void_;
            }
        }

        public Void updateToScheduled(String partitionToken) {
            try (Scope scope = TRACER.spanBuilder("updateToScheduled").setRecordEvents(true).startScopedSpan();){
                TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partitionToken));
                this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.SCHEDULED)));
                Void void_ = null;
                return void_;
            }
        }

        public Void updateToRunning(String partitionToken) {
            try (Scope scope = TRACER.spanBuilder("updateToRunning").setRecordEvents(true).startScopedSpan();){
                TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partitionToken));
                this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.RUNNING)));
                Void void_ = null;
                return void_;
            }
        }

        public Void updateToFinished(String partitionToken) {
            try (Scope scope = TRACER.spanBuilder("updateToRunning").setRecordEvents(true).startScopedSpan();){
                TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partitionToken));
                this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.FINISHED)));
                Void void_ = null;
                return void_;
            }
        }

        public Void updateWatermark(String partitionToken, Timestamp watermark) {
            try (Scope scope = TRACER.spanBuilder("updateCurrentWatermark").setRecordEvents(true).startScopedSpan();){
                TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partitionToken));
                this.transaction.buffer(this.createUpdateMetadataWatermarkMutationFrom(partitionToken, watermark));
                Void void_ = null;
                return void_;
            }
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public Struct getPartition(String partitionToken) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Mutation createInsertMetadataMutationFrom(PartitionMetadata partitionMetadata) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionMetadata.getPartitionToken())).set("ParentTokens").toStringArray(partitionMetadata.getParentTokens())).set("StartTimestamp").to(partitionMetadata.getStartTimestamp())).set("EndTimestamp").to(partitionMetadata.getEndTimestamp())).set("HeartbeatMillis").to(partitionMetadata.getHeartbeatMillis())).set("State").to(partitionMetadata.getState().toString())).set("Watermark").to(partitionMetadata.getWatermark())).set("CreatedAt").to(Value.COMMIT_TIMESTAMP)).build();
        }

        private Mutation createUpdateMetadataStateMutationFrom(String partitionToken, PartitionMetadata.State state) {
            String timestampColumn = this.stateToTimestampColumn.get((Object)state);
            if (timestampColumn == null) {
                throw new IllegalArgumentException("No timestamp column name found for state " + (Object)((Object)state));
            }
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("State").to(state.toString())).set(timestampColumn).to(Value.COMMIT_TIMESTAMP)).build();
        }

        private Mutation createUpdateMetadataWatermarkMutationFrom(String partitionToken, Timestamp watermark) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("Watermark").to(watermark)).build();
        }
    }
}

