/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.Uuid;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;

public class AddUuidsTransform
extends PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> {
    private static PubSubMessage addUuid(PubSubMessage message) {
        PubSubMessage.Builder builder = message.toBuilder();
        builder.putAttributes("x-goog-pubsublite-dataflow-uuid", AttributeValues.newBuilder().addValues(Uuid.random().value()).build());
        return builder.build();
    }

    public PCollection<PubSubMessage> expand(PCollection<PubSubMessage> input) {
        PCollection withUuids = (PCollection)input.apply("AddUuids", (PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<PubSubMessage>(){}).via(AddUuidsTransform::addUuid));
        return (PCollection)withUuids.apply("ShuffleToPersist", (PTransform)Reshuffle.viaRandomKey().withNumBuckets(Integer.valueOf(1000)));
    }
}

