/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessages;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;

public final class CloudPubsubTransforms {
    private CloudPubsubTransforms() {
    }

    public static PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> ensureUsableAsCloudPubsub() {
        return new PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>>(){

            public PCollection<PubSubMessage> expand(PCollection<PubSubMessage> input) {
                return (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubSubMessage.class)).via((SerializableFunction & Serializable)message -> {
                    Object unused = MessageTransforms.toCpsPublishTransformer().transform((Object)Message.fromProto((PubSubMessage)message));
                    return message;
                }));
            }
        };
    }

    public static PTransform<PCollection<SequencedMessage>, PCollection<PubsubMessage>> toCloudPubsubMessages() {
        return new PTransform<PCollection<SequencedMessage>, PCollection<PubsubMessage>>(){

            public PCollection<PubsubMessage> expand(PCollection<SequencedMessage> input) {
                return (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via((SerializableFunction & Serializable)message -> PubsubMessages.fromProto((com.google.pubsub.v1.PubsubMessage)MessageTransforms.toCpsSubscribeTransformer().transform((Object)com.google.cloud.pubsublite.SequencedMessage.fromProto((SequencedMessage)message)))));
            }
        };
    }

    public static PTransform<PCollection<PubsubMessage>, PCollection<PubSubMessage>> fromCloudPubsubMessages() {
        return new PTransform<PCollection<PubsubMessage>, PCollection<PubSubMessage>>(){

            public PCollection<PubSubMessage> expand(PCollection<PubsubMessage> input) {
                return (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubSubMessage.class)).via((SerializableFunction & Serializable)message -> ((Message)MessageTransforms.fromCpsPublishTransformer((KeyExtractor)KeyExtractor.DEFAULT).transform((Object)PubsubMessages.toProto(message))).toProto()));
            }
        };
    }
}

