/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Utf8;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecordAction {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangeRecordAction.class);

    @VisibleForTesting
    public Optional<DoFn.ProcessContinuation> run(PartitionMetadata partition, DataChangeRecord record, RestrictionTracker<TimestampRange, Timestamp> tracker, DoFn.OutputReceiver<DataChangeRecord> outputReceiver, ManualWatermarkEstimator<Instant> watermarkEstimator, ThroughputEstimator throughputEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[" + token + "] Processing data record " + record.getCommitTimestamp());
        Timestamp commitTimestamp = record.getCommitTimestamp();
        Instant commitInstant = new Instant(commitTimestamp.toSqlTimestamp().getTime());
        if (!tracker.tryClaim((Object)commitTimestamp)) {
            LOG.debug("[" + token + "] Could not claim queryChangeStream(" + commitTimestamp + "), stopping");
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        outputReceiver.outputWithTimestamp((Object)record, commitInstant);
        watermarkEstimator.setWatermark(commitInstant);
        throughputEstimator.update(Timestamp.now(), Utf8.encodedLength((CharSequence)record.toString()));
        LOG.debug("[" + token + "] Data record action completed successfully");
        return Optional.empty();
    }
}

