/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryResourceNaming {
    BigQueryResourceNaming() {
    }

    static @UnknownKeyFor @NonNull @Initialized String createJobIdWithDestination(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized int partition, @UnknownKeyFor @NonNull @Initialized long index) {
        String destinationHash = Hashing.murmur3_128().hashUnencodedChars((CharSequence)tableDestination.toString()).toString();
        String jobId = String.format("%s_%s", prefix, destinationHash);
        if (partition >= 0) {
            jobId = jobId + String.format("_%05d", partition);
        }
        if (index >= 0L) {
            jobId = jobId + String.format("_%05d", index);
        }
        return jobId;
    }

    static @UnknownKeyFor @NonNull @Initialized String createJobIdPrefix(@UnknownKeyFor @NonNull @Initialized String jobName, @UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized JobType type, @Nullable @UnknownKeyFor @Initialized String random) {
        jobName = jobName.replaceAll("-", "");
        String result = "beam_bq_job_{TYPE}_{JOB_ID}_{STEP}_{RANDOM}".replaceFirst("\\{TYPE}", type.toString()).replaceFirst("\\{JOB_ID}", jobName).replaceFirst("\\{STEP}", stepUuid);
        if (random != null) {
            return result.replaceFirst("\\{RANDOM}", random);
        }
        return result.replaceFirst("_\\{RANDOM}", "");
    }

    static @UnknownKeyFor @NonNull @Initialized String createJobIdPrefix(@UnknownKeyFor @NonNull @Initialized String jobName, @UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized JobType type) {
        return BigQueryResourceNaming.createJobIdPrefix(jobName, stepUuid, type, null);
    }

    static @UnknownKeyFor @NonNull @Initialized TableReference createTempTableReference(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String jobUuid, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> tempDatasetIdOpt) {
        String tempDatasetId = tempDatasetIdOpt.orElse("temp_dataset_" + jobUuid);
        String queryTempTableId = "temp_table_" + jobUuid;
        return new TableReference().setProjectId(projectId).setDatasetId(tempDatasetId).setTableId(queryTempTableId);
    }

    public static enum JobType {
        LOAD,
        TEMP_TABLE_LOAD,
        COPY,
        EXPORT,
        QUERY;

    }
}

