/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.arrow.ArrowConversion;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryStorageArrowReader
implements BigQueryStorageReader {
    @Nullable
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ArrowConversion.RecordBatchRowIterator recordBatchIterator;
    private @UnknownKeyFor @NonNull @Initialized long rowCount;
    private @UnknownKeyFor @NonNull @Initialized ArrowSchema protoSchema;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RootAllocator alloc;

    BigQueryStorageArrowReader(@UnknownKeyFor @NonNull @Initialized ReadSession readSession) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.protoSchema = readSession.getArrowSchema();
        this.rowCount = 0L;
        this.alloc = null;
    }

    @Override
    public void processReadRowsResponse(@UnknownKeyFor @NonNull @Initialized ReadRowsResponse readRowsResponse) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RootAllocator alloc;
        ArrowRecordBatch recordBatch = readRowsResponse.getArrowRecordBatch();
        this.rowCount = recordBatch.getRowCount();
        InputStream input = this.protoSchema.getSerializedSchema().newInput();
        Schema arrowSchema = ArrowConversion.arrowSchemaFromInput((InputStream)input);
        this.alloc = alloc = new RootAllocator(Long.MAX_VALUE);
        this.recordBatchIterator = ArrowConversion.rowsFromSerializedRecordBatch((Schema)arrowSchema, (InputStream)recordBatch.getSerializedRecordBatch().newInput(), (RootAllocator)alloc);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getRowCount() {
        return this.rowCount;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized GenericRecord readSingleRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.recordBatchIterator == null) {
            throw new IOException("Not Initialized");
        }
        Row row = this.recordBatchIterator.next();
        return AvroUtils.toGenericRecord((Row)row, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean readyForNextReadResponse() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.recordBatchIterator == null || !this.recordBatchIterator.hasNext();
    }

    @Override
    public void resetBuffer() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.recordBatchIterator != null) {
            this.recordBatchIterator.close();
            this.recordBatchIterator = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }
}

