/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BatchedStreamingWrite;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertErrorCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.GenerateShardedTable;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TagWithUniqueIds;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StreamingWriteTables<@UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<TableDestination, ElementT>>, WriteResult> {
    private @UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices;
    private @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy;
    private @UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo;
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_INSERTS_TAG_ID = "failedInserts";
    private final @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoSharding;
    private final @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful;
    private final @Nullable @UnknownKeyFor @Initialized Coder<ElementT> elementCoder;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn;

    public StreamingWriteTables() {
        this(new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry(), false, false, false, false, false, false, null, null, null, null);
    }

    private StreamingWriteTables(@UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized boolean autoSharding, @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful, @Nullable @UnknownKeyFor @Initialized Coder<ElementT> elementCoder, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn) {
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.autoSharding = autoSharding;
        this.propagateSuccessful = propagateSuccessful;
        this.elementCoder = elementCoder;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.deterministicRecordIdFn = deterministicRecordIdFn;
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices) {
        return new StreamingWriteTables<ElementT>(bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withExtendedErrorInfo(@UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withSkipInvalidRows(@UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withIgnoreUnknownValues(@UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withIgnoreInsertIds(@UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withAutoSharding(@UnknownKeyFor @NonNull @Initialized boolean autoSharding) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withPropagateSuccessful(@UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withElementCoder(@UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withToTableRow(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withToFailsafeTableRow(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, toFailsafeTableRow, this.deterministicRecordIdFn);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingWriteTables<ElementT> withDeterministicRecordIdFn(@Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, deterministicRecordIdFn);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination, ElementT>> input) {
        Preconditions.checkStateNotNull(this.elementCoder);
        if (this.extendedErrorInfo) {
            TupleTag failedInsertsTag = new TupleTag(FAILED_INSERTS_TAG_ID);
            PCollectionTuple result = this.writeAndGetErrors(input, failedInsertsTag, BigQueryInsertErrorCoder.of(), ErrorContainer.BIG_QUERY_INSERT_ERROR_ERROR_CONTAINER);
            PCollection failedInserts = result.get(failedInsertsTag);
            return WriteResult.withExtendedErrors(input.getPipeline(), (TupleTag<BigQueryInsertError>)failedInsertsTag, (PCollection<BigQueryInsertError>)failedInserts, this.propagateSuccessful ? result.get(BatchedStreamingWrite.SUCCESSFUL_ROWS_TAG) : null);
        }
        TupleTag failedInsertsTag = new TupleTag(FAILED_INSERTS_TAG_ID);
        PCollectionTuple result = this.writeAndGetErrors(input, failedInsertsTag, TableRowJsonCoder.of(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER);
        PCollection failedInserts = result.get(failedInsertsTag);
        return WriteResult.in(input.getPipeline(), (TupleTag<TableRow>)failedInsertsTag, (PCollection<TableRow>)failedInserts, (PCollection<TableRow>)(this.propagateSuccessful ? result.get(BatchedStreamingWrite.SUCCESSFUL_ROWS_TAG) : null), null, null, null, null);
    }

    @RequiresNonNull(value={"elementCoder"})
    private <T> @UnknownKeyFor @NonNull @Initialized PCollectionTuple writeAndGetErrors(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination, ElementT>> input, @UnknownKeyFor @NonNull @Initialized TupleTag<T> failedInsertsTag, @UnknownKeyFor @NonNull @Initialized AtomicCoder<T> coder, @UnknownKeyFor @NonNull @Initialized ErrorContainer<T> errorContainer) {
        BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        if (this.autoSharding && this.deterministicRecordIdFn == null) {
            PCollection unshardedTagged = ((PCollection)((PCollection)input.apply("MapToTableSpec", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<TableDestination, ElementT>, KV<String, ElementT>>(){

                public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, ElementT> apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination, ElementT> input) {
                    return KV.of((Object)((TableDestination)input.getKey()).getTableSpec(), (Object)input.getValue());
                }
            }))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), this.elementCoder)).apply("TagWithUniqueIds", (PTransform)ParDo.of(new TagWithUniqueIds()))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), TableRowInfoCoder.of(this.elementCoder)));
            return (PCollectionTuple)unshardedTagged.apply("StreamingWrite", new BatchedStreamingWrite<T, ElementT>(this.bigQueryServices, this.retryPolicy, failedInsertsTag, coder, errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.propagateSuccessful, this.toTableRow, this.toFailsafeTableRow).viaStateful());
        }
        int numShards = options.getNumStreamingKeys();
        PCollection shardedTagged = ((PCollection)((PCollection)input.apply("ShardTableWrites", (PTransform)ParDo.of(new GenerateShardedTable(numShards)))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), this.elementCoder)).apply("TagWithUniqueIds", (PTransform)ParDo.of(new TagWithUniqueIds(this.deterministicRecordIdFn)))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), TableRowInfoCoder.of(this.elementCoder)));
        if (this.deterministicRecordIdFn == null) {
            shardedTagged = (PCollection)shardedTagged.apply((PTransform)Reshuffle.of());
        }
        return (PCollectionTuple)((PCollection)((PCollection)shardedTagged.apply("GlobalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("StripShardId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<ShardedKey<String>, TableRowInfo<ElementT>>, KV<String, TableRowInfo<ElementT>>>(){

            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>> apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>> input) {
                return KV.of((Object)((String)((ShardedKey)input.getKey()).getKey()), (Object)((TableRowInfo)input.getValue()));
            }
        }))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), TableRowInfoCoder.of(this.elementCoder))).apply("StreamingWrite", new BatchedStreamingWrite<T, ElementT>(this.bigQueryServices, this.retryPolicy, failedInsertsTag, coder, errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.propagateSuccessful, this.toTableRow, this.toFailsafeTableRow).viaDoFnFinalization());
    }
}

