/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration_ErrorHandling;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoService(value={SchemaTransformProvider.class})
public class BigQueryStorageWriteApiSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryStorageWriteApiSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_TRIGGER_FREQUENCY_SECS = 5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_TRIGGERING_FREQUENCY = Duration.standardSeconds((long)DEFAULT_TRIGGER_FREQUENCY_SECS.intValue());
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_TAG = "FailedRows";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_WITH_ERRORS_TAG = "FailedRowsWithErrors";
    protected static final @UnknownKeyFor @NonNull @Initialized String DYNAMIC_DESTINATIONS = "DYNAMIC_DESTINATIONS";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration> configurationClass() {
        return BigQueryStorageWriteApiSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
        return new BigQueryStorageWriteApiSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("beam:schematransform:org.apache.beam:bigquery_storage_write:v2", new Object[0]);
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return String.format("Writes data to BigQuery using the Storage Write API (https://cloud.google.com/bigquery/docs/write-api).\n\nThis expects a single PCollection of Beam Rows and outputs two dead-letter queues (DLQ) that contain failed rows. The first DLQ has tag [%s] and contains the failed rows. The second DLQ has tag [%s] and contains failed rows and along with their respective errors.", FAILED_ROWS_TAG, FAILED_ROWS_WITH_ERRORS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList(FAILED_ROWS_TAG, FAILED_ROWS_WITH_ERRORS_TAG, "errors");
    }

    protected static class BigQueryStorageWriteApiSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration;

        BigQueryStorageWriteApiSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        @VisibleForTesting
        public void setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.has(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG), (String)"Missing expected input tag: %s", (Object)BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            PCollection inputRows = input.get(BigQueryStorageWriteApiSchemaTransformProvider.INPUT_ROWS_TAG);
            BigQueryIO.Write<Row> write = this.createStorageWriteApiTransform(inputRows.getSchema());
            if (inputRows.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                boolean useAtLeastOnceSemantics;
                Long triggeringFrequency = this.configuration.getTriggeringFrequencySeconds();
                Boolean autoSharding = this.configuration.getAutoSharding();
                int numStreams = this.configuration.getNumStreams() == null ? 0 : this.configuration.getNumStreams();
                boolean bl = useAtLeastOnceSemantics = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false;
                if (!useAtLeastOnceSemantics) {
                    write = write.withTriggeringFrequency(triggeringFrequency == null || triggeringFrequency <= 0L ? DEFAULT_TRIGGERING_FREQUENCY : Duration.standardSeconds((long)triggeringFrequency));
                }
                if (numStreams > 0) {
                    write = write.withNumStorageWriteApiStreams(numStreams);
                } else if (autoSharding == null || autoSharding.booleanValue()) {
                    write = write.withAutoSharding();
                }
            }
            Schema inputSchema = inputRows.getSchema();
            WriteResult result = (WriteResult)((PCollection)inputRows.apply("element-count", (PTransform)ParDo.of(new ElementCounterFn("BigQuery-write-element-counter")))).setRowSchema(inputSchema).apply(write);
            PCollection postWrite = ((PCollection)result.getFailedStorageApiInserts().apply("post-write", (PTransform)ParDo.of(new NoOutputDoFn()))).setRowSchema(Schema.of((Schema.Field[])new Schema.Field[0]));
            if (this.configuration.getErrorHandling() == null) {
                result.getFailedStorageApiInserts().apply("Error on failed inserts", (PTransform)ParDo.of((DoFn)new FailOnError()));
                return PCollectionRowTuple.of((String)"post_write", (PCollection)postWrite);
            }
            result.getFailedStorageApiInserts().apply("error-count", (PTransform)ParDo.of(new ElementCounterFn("BigQuery-write-error-counter")));
            Schema errorSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"failed_row", (Schema.FieldType)Schema.FieldType.row((Schema)inputSchema)), Schema.Field.of((String)"error_message", (Schema.FieldType)Schema.FieldType.STRING)});
            PCollection failedRowsWithErrors = ((PCollection)result.getFailedStorageApiInserts().apply("Construct failed rows and errors", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)storageError -> Row.withSchema((Schema)errorSchema).withFieldValue("error_message", (Object)storageError.getErrorMessage()).withFieldValue("failed_row", (Object)BigQueryUtils.toBeamRow(inputSchema, storageError.getRow())).build()))).setRowSchema(errorSchema);
            return PCollectionRowTuple.of((String)"post_write", (PCollection)postWrite).and(this.configuration.getErrorHandling().getOutput(), failedRowsWithErrors);
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized Row> createStorageWriteApiTransform(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            BigQueryIO.Write.Method writeMethod = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false ? BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE : BigQueryIO.Write.Method.STORAGE_WRITE_API;
            BigQueryIO.Write<Row> write = BigQueryIO.write().withMethod(writeMethod).withFormatFunction(BigQueryUtils.toTableRow()).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND);
            if (this.configuration.getTable().equals(BigQueryStorageWriteApiSchemaTransformProvider.DYNAMIC_DESTINATIONS)) {
                Preconditions.checkArgument((boolean)schema.getFieldNames().equals(Arrays.asList("destination", "record")), (Object)"When writing to dynamic destinations, we expect Row Schema with a \"destination\" string field and a \"record\" Row field.");
                write = write.to(new RowDynamicDestinations(schema.getField("record").getType().getRowSchema())).withFormatFunction((SerializableFunction<Row, TableRow>)(SerializableFunction & Serializable)row -> BigQueryUtils.toTableRow(row.getRow("record")));
            } else {
                write = write.to(this.configuration.getTable()).useBeamSchema();
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getCreateDisposition())) {
                BigQueryIO.Write.CreateDisposition createDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.CREATE_DISPOSITIONS.get(this.configuration.getCreateDisposition().toUpperCase());
                write = write.withCreateDisposition(createDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getWriteDisposition())) {
                BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryStorageWriteApiSchemaTransformConfiguration.WRITE_DISPOSITIONS.get(this.configuration.getWriteDisposition().toUpperCase());
                write = write.withWriteDisposition(writeDisposition);
            }
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            return write;
        }

        private static class RowDynamicDestinations
        extends DynamicDestinations<Row, String> {
            @UnknownKeyFor @NonNull @Initialized Schema schema;

            RowDynamicDestinations(@UnknownKeyFor @NonNull @Initialized Schema schema) {
                this.schema = schema;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getDestination(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Row> element) {
                return ((Row)element.getValue()).getString("destination");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized String destination) {
                return new TableDestination(destination, null);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized String destination) {
                return BigQueryUtils.toTableSchema(this.schema);
            }
        }

        private static class NoOutputDoFn<@UnknownKeyFor T>
        extends DoFn<T, Row> {
            private NoOutputDoFn() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            }
        }

        private static class FailOnError
        extends DoFn<BigQueryStorageApiInsertError, Void> {
            private FailOnError() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                throw new RuntimeException(((BigQueryStorageApiInsertError)c.element()).getErrorMessage());
            }
        }

        private static class ElementCounterFn<@UnknownKeyFor T>
        extends DoFn<T, T> {
            private @UnknownKeyFor @NonNull @Initialized Counter bqGenericElementCounter;
            private @UnknownKeyFor @NonNull @Initialized Long elementsInBundle = 0L;

            ElementCounterFn(@UnknownKeyFor @NonNull @Initialized String name) {
                this.bqGenericElementCounter = Metrics.counter(BigQueryStorageWriteApiSchemaTransform.class, (String)name);
            }

            @DoFn.ProcessElement
            public void process(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                this.elementsInBundle = this.elementsInBundle + 1L;
                c.output(c.element());
            }

            @DoFn.FinishBundle
            public void finish(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.bqGenericElementCounter.inc(this.elementsInBundle.longValue());
                this.elementsInBundle = 0L;
            }
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigQueryStorageWriteApiSchemaTransformConfiguration {
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition> CREATE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).put((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name(), (Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER).build();
        static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition> WRITE_DISPOSITIONS = ImmutableMap.builder().put((Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY).put((Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name(), (Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND).build();

        public void validate() {
            String invalidConfigMessage = "Invalid BigQuery Storage Write configuration: ";
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTable()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table spec for a BigQuery Write must be specified."));
            if (!this.getTable().equals(BigQueryStorageWriteApiSchemaTransformProvider.DYNAMIC_DESTINATIONS)) {
                Preconditions.checkNotNull((Object)BigQueryHelpers.parseTableSpec(this.getTable()));
            }
            if (!Strings.isNullOrEmpty((String)this.getCreateDisposition())) {
                Preconditions.checkNotNull((Object)((Object)CREATE_DISPOSITIONS.get(this.getCreateDisposition().toUpperCase())), (String)(invalidConfigMessage + "Invalid create disposition (%s) was specified. Available dispositions are: %s"), (Object)this.getCreateDisposition(), CREATE_DISPOSITIONS.keySet());
            }
            if (!Strings.isNullOrEmpty((String)this.getWriteDisposition())) {
                Preconditions.checkNotNull((Object)((Object)WRITE_DISPOSITIONS.get(this.getWriteDisposition().toUpperCase())), (String)(invalidConfigMessage + "Invalid write disposition (%s) was specified. Available dispositions are: %s"), (Object)this.getWriteDisposition(), WRITE_DISPOSITIONS.keySet());
            }
            if (this.getErrorHandling() != null) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getErrorHandling().getOutput()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Output must not be empty if error handling specified."));
            }
            if (this.getAutoSharding() != null && this.getAutoSharding().booleanValue() && this.getNumStreams() != null) {
                Preconditions.checkArgument((this.getNumStreams() == 0 ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Cannot set a fixed number of streams when auto-sharding is enabled. Please pick only one of the two options."));
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration.Builder();
        }

        @SchemaFieldDescription(value="The bigquery table to write to. Format: [${PROJECT}:]${DATASET}.${TABLE}")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTable();

        @SchemaFieldDescription(value="Optional field that specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED (the job may create the table), CREATE_NEVER (the job must fail if the table does not exist already).")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getCreateDisposition();

        @SchemaFieldDescription(value="Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE (overwrites the table data), WRITE_APPEND (append the data to the table), WRITE_EMPTY (job must fail if the table is not empty).")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getWriteDisposition();

        @SchemaFieldDescription(value="Determines how often to 'commit' progress into BigQuery. Default is every 5 seconds.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Long getTriggeringFrequencySeconds();

        @SchemaFieldDescription(value="This option enables lower latency for insertions to BigQuery but may ocassionally duplicate data elements.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getUseAtLeastOnceSemantics();

        @SchemaFieldDescription(value="This option enables using a dynamically determined number of Storage Write API streams to write to BigQuery. Only applicable to unbounded data.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getAutoSharding();

        @SchemaFieldDescription(value="Specifies the number of write streams that the Storage API sink will use. This parameter is only applicable when writing unbounded data.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Integer getNumStreams();

        @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized ErrorHandling getErrorHandling();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCreateDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTriggeringFrequencySeconds(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUseAtLeastOnceSemantics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoSharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumStreams(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigQueryStorageWriteApiSchemaTransformConfiguration build();
        }

        @AutoValue
        public static abstract class ErrorHandling {
            @SchemaFieldDescription(value="The name of the output PCollection containing failed writes.")
            public abstract @UnknownKeyFor @NonNull @Initialized String getOutput();

            public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
                return new AutoValue_BigQueryStorageWriteApiSchemaTransformProvider_BigQueryStorageWriteApiSchemaTransformConfiguration_ErrorHandling.Builder();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutput(@UnknownKeyFor @NonNull @Initialized String var1);

                public abstract @UnknownKeyFor @NonNull @Initialized ErrorHandling build();
            }
        }
    }
}

