/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.BigtableClientOverride;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.threeten.bp.Duration;

@Internal
public class BigtableChangeStreamAccessor
implements AutoCloseable {
    static final @UnknownKeyFor @NonNull @Initialized Duration MUTATE_ROW_DEADLINE = Duration.ofSeconds((long)30L);
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized BigtableConfig, @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor> bigtableAccessors = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableConfig bigtableConfig;

    private BigtableChangeStreamAccessor(@UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient, @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient, @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient, @UnknownKeyFor @NonNull @Initialized BigtableConfig bigtableConfig) {
        this.dataClient = dataClient;
        this.tableAdminClient = tableAdminClient;
        this.instanceAdminClient = instanceAdminClient;
        this.bigtableConfig = bigtableConfig;
    }

    @Override
    public synchronized void close() {
        if (this.dataClient != null) {
            this.dataClient.close();
        }
        if (this.tableAdminClient != null) {
            this.tableAdminClient.close();
        }
        if (this.instanceAdminClient != null) {
            this.instanceAdminClient.close();
        }
        bigtableAccessors.remove(this.bigtableConfig);
    }

    public static synchronized @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor getOrCreate(@NonNull @UnknownKeyFor @Initialized BigtableConfig bigtableConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (bigtableAccessors.get(bigtableConfig) == null) {
            BigtableChangeStreamAccessor bigtableAccessor = BigtableChangeStreamAccessor.createAccessor(bigtableConfig);
            bigtableAccessors.put(bigtableConfig, bigtableAccessor);
        }
        return (BigtableChangeStreamAccessor)Preconditions.checkStateNotNull((Object)bigtableAccessors.get(bigtableConfig));
    }

    private static @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor createAccessor(@NonNull @UnknownKeyFor @Initialized BigtableConfig bigtableConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String projectId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getProjectId())).get();
        String instanceId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getInstanceId())).get();
        BigtableDataSettings.Builder dataSettingsBuilder = BigtableDataSettings.newBuilder();
        BigtableTableAdminSettings.Builder tableAdminSettingsBuilder = BigtableTableAdminSettings.newBuilder();
        BigtableInstanceAdminSettings.Builder instanceAdminSettingsBuilder = BigtableInstanceAdminSettings.newBuilder();
        dataSettingsBuilder.setProjectId(projectId);
        tableAdminSettingsBuilder.setProjectId(projectId);
        instanceAdminSettingsBuilder.setProjectId(projectId);
        dataSettingsBuilder.setInstanceId(instanceId);
        tableAdminSettingsBuilder.setInstanceId(instanceId);
        String appProfileId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getAppProfileId())).get();
        dataSettingsBuilder.setAppProfileId(appProfileId);
        dataSettingsBuilder.stubSettings().setTransportChannelProvider((TransportChannelProvider)EnhancedBigtableStubSettings.defaultGrpcTransportProviderBuilder().setAttemptDirectPath(false).setChannelPoolSettings(ChannelPoolSettings.builder().setMinChannelCount(2).setMaxChannelCount(100).setInitialChannelCount(5).setPreemptiveRefreshEnabled(true).setMinRpcsPerChannel(10).setMaxRpcsPerChannel(50).build()).build());
        RetrySettings.Builder readRowRetrySettings = dataSettingsBuilder.stubSettings().readRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readRowSettings().setRetrySettings(readRowRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder readRowsRetrySettings = dataSettingsBuilder.stubSettings().readRowsSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readRowsSettings().setRetrySettings(readRowsRetrySettings.setInitialRpcTimeout(Duration.ofMinutes((long)3L)).setTotalTimeout(Duration.ofMinutes((long)3L)).setMaxRpcTimeout(Duration.ofMinutes((long)3L)).setMaxAttempts(10).build());
        RetrySettings.Builder mutateRowRetrySettings = dataSettingsBuilder.stubSettings().mutateRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().mutateRowSettings().setRetrySettings(mutateRowRetrySettings.setInitialRpcTimeout(MUTATE_ROW_DEADLINE).setTotalTimeout(MUTATE_ROW_DEADLINE).setMaxRpcTimeout(MUTATE_ROW_DEADLINE).setMaxAttempts(10).build());
        RetrySettings.Builder checkAndMutateRowRetrySettings = dataSettingsBuilder.stubSettings().checkAndMutateRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().checkAndMutateRowSettings().setRetrySettings(checkAndMutateRowRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder readChangeStreamRetrySettings = dataSettingsBuilder.stubSettings().readChangeStreamSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readChangeStreamSettings().setRetrySettings(readChangeStreamRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)15L)).setTotalTimeout(Duration.ofSeconds((long)15L)).setMaxRpcTimeout(Duration.ofSeconds((long)15L)).setMaxAttempts(10).build());
        BigtableClientOverride clientOverride = bigtableConfig.getBigtableClientOverride();
        if (clientOverride != null) {
            clientOverride.updateTableAdminClientSettings(tableAdminSettingsBuilder);
            clientOverride.updateInstanceAdminClientSettings(instanceAdminSettingsBuilder);
            clientOverride.updateDataClientSettings(dataSettingsBuilder);
        }
        BigtableDataClient dataClient = BigtableDataClient.create((BigtableDataSettings)dataSettingsBuilder.build());
        BigtableTableAdminClient tableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)tableAdminSettingsBuilder.build());
        BigtableInstanceAdminClient instanceAdminClient = BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)instanceAdminSettingsBuilder.build());
        return new BigtableChangeStreamAccessor(dataClient, tableAdminClient, instanceAdminClient, bigtableConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient getInstanceAdminClient() {
        return this.instanceAdminClient;
    }
}

