/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesAndMessageIdCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubMessageWithTopicCoder
extends CustomCoder<PubsubMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> PAYLOAD_CODER = ByteArrayCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> ATTRIBUTES_CODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable @UnknownKeyFor @Initialized String> MESSAGE_ID_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable @UnknownKeyFor @Initialized String> TOPIC_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PubsubMessage> of(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized PubsubMessage> ignored) {
        return PubsubMessageWithTopicCoder.of();
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubMessageWithAttributesAndMessageIdCoder of() {
        return new PubsubMessageWithAttributesAndMessageIdCoder();
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized PubsubMessage value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream);
        ATTRIBUTES_CODER.encode(value.getAttributeMap(), outStream);
        MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
        TOPIC_CODER.encode((Object)value.getTopic(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized PubsubMessage decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] payload = (byte[])PAYLOAD_CODER.decode(inStream);
        @Nullable Map attributes = (Map)ATTRIBUTES_CODER.decode(inStream);
        @Nullable String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
        @Nullable String topic = (String)TOPIC_CODER.decode(inStream);
        PubsubMessage pubsubMessage = new PubsubMessage(payload, attributes, messageId);
        if (topic != null) {
            pubsubMessage = pubsubMessage.withTopic(topic);
        }
        return pubsubMessage;
    }
}

