/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Dialect;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataAdminDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DaoFactory
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 7929063669009832487L;
    private transient @UnknownKeyFor @NonNull @Initialized PartitionMetadataAdminDao partitionMetadataAdminDao;
    private transient @UnknownKeyFor @NonNull @Initialized PartitionMetadataDao partitionMetadataDaoInstance;
    private transient @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDaoInstance;
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig changeStreamSpannerConfig;
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig metadataSpannerConfig;
    private final @UnknownKeyFor @NonNull @Initialized String changeStreamName;
    private final @UnknownKeyFor @NonNull @Initialized String partitionMetadataTableName;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority;
    private final @UnknownKeyFor @NonNull @Initialized String jobName;
    private final @UnknownKeyFor @NonNull @Initialized Dialect spannerChangeStreamDatabaseDialect;
    private final @UnknownKeyFor @NonNull @Initialized Dialect metadataDatabaseDialect;

    public DaoFactory(@UnknownKeyFor @NonNull @Initialized SpannerConfig changeStreamSpannerConfig, @UnknownKeyFor @NonNull @Initialized String changeStreamName, @UnknownKeyFor @NonNull @Initialized SpannerConfig metadataSpannerConfig, @UnknownKeyFor @NonNull @Initialized String partitionMetadataTableName, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority, @UnknownKeyFor @NonNull @Initialized String jobName, @UnknownKeyFor @NonNull @Initialized Dialect spannerChangeStreamDatabaseDialect, @UnknownKeyFor @NonNull @Initialized Dialect metadataDatabaseDialect) {
        if (metadataSpannerConfig.getInstanceId() == null) {
            throw new IllegalArgumentException("Metadata instance can not be null");
        }
        if (metadataSpannerConfig.getDatabaseId() == null) {
            throw new IllegalArgumentException("Metadata database can not be null");
        }
        this.changeStreamSpannerConfig = changeStreamSpannerConfig;
        this.changeStreamName = changeStreamName;
        this.metadataSpannerConfig = metadataSpannerConfig;
        this.partitionMetadataTableName = partitionMetadataTableName;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
        this.spannerChangeStreamDatabaseDialect = spannerChangeStreamDatabaseDialect;
        this.metadataDatabaseDialect = metadataDatabaseDialect;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized PartitionMetadataAdminDao getPartitionMetadataAdminDao() {
        if (this.partitionMetadataAdminDao == null) {
            DatabaseAdminClient databaseAdminClient = SpannerAccessor.getOrCreate(this.metadataSpannerConfig).getDatabaseAdminClient();
            this.partitionMetadataAdminDao = new PartitionMetadataAdminDao(databaseAdminClient, (String)this.metadataSpannerConfig.getInstanceId().get(), (String)this.metadataSpannerConfig.getDatabaseId().get(), this.partitionMetadataTableName, this.metadataDatabaseDialect);
        }
        return this.partitionMetadataAdminDao;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized PartitionMetadataDao getPartitionMetadataDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.metadataSpannerConfig);
        if (this.partitionMetadataDaoInstance == null) {
            this.partitionMetadataDaoInstance = new PartitionMetadataDao(this.partitionMetadataTableName, spannerAccessor.getDatabaseClient(), this.metadataDatabaseDialect);
        }
        return this.partitionMetadataDaoInstance;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized ChangeStreamDao getChangeStreamDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.changeStreamSpannerConfig);
        if (this.changeStreamDaoInstance == null) {
            this.changeStreamDaoInstance = new ChangeStreamDao(this.changeStreamName, spannerAccessor.getDatabaseClient(), this.rpcPriority, this.jobName, this.spannerChangeStreamDatabaseDialect);
        }
        return this.changeStreamDaoInstance;
    }
}

