/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ManagedFactoryImpl<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized AutoCloseable>
implements ManagedFactory<T> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition, T> newInstance;
    @GuardedBy(value="this")
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition, T> instances = new HashMap<SubscriptionPartition, T>();

    ManagedFactoryImpl(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition, T> newInstance) {
        this.newInstance = newInstance;
    }

    @Override
    public synchronized T create(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        return (T)this.instances.computeIfAbsent(subscriptionPartition, arg_0 -> this.newInstance.apply(arg_0));
    }

    @Override
    public synchronized void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Exception e = null;
        for (AutoCloseable c : this.instances.values()) {
            try {
                c.close();
            }
            catch (Exception e2) {
                if (e == null) {
                    e = e2;
                    continue;
                }
                e.addSuppressed(e2);
            }
        }
        if (e != null) {
            throw e;
        }
    }
}

