/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.math.LongMath;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.UnsignedInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class OrderedCode {
    static final @UnknownKeyFor @NonNull @Initialized byte ESCAPE1 = 0;
    static final @UnknownKeyFor @NonNull @Initialized byte NULL_CHARACTER = -1;
    static final @UnknownKeyFor @NonNull @Initialized byte SEPARATOR = 1;
    static final @UnknownKeyFor @NonNull @Initialized byte ESCAPE2 = -1;
    static final @UnknownKeyFor @NonNull @Initialized byte INFINITY = -1;
    static final @UnknownKeyFor @NonNull @Initialized byte FF_CHARACTER = 0;
    static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] ESCAPE1_SEPARATOR = new byte[]{0, 1};
    static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] INFINITY_ENCODED = new byte[]{-1, -1};
    static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] INFINITY_ENCODED_DECREASING = new byte[]{OrderedCode.invert((byte)-1), OrderedCode.invert((byte)-1)};
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] LENGTH_TO_HEADER_BITS = new byte[][]{{0, 0}, {-128, 0}, {-64, 0}, {-32, 0}, {-16, 0}, {-8, 0}, {-4, 0}, {-2, 0}, {-1, 0}, {-1, -128}, {-1, -64}};
    private static final @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] LENGTH_TO_MASK = new long[]{0L, 128L, 49152L, 0xE00000L, 0xF0000000L, 0xF800000000L, 0xFC0000000000L, 0xFE000000000000L, -72057594037927936L, Long.MIN_VALUE, 0L};
    private static final @UnknownKeyFor @NonNull @Initialized short @UnknownKeyFor @NonNull @Initialized [] BITS_TO_LENGTH = new short[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10};
    private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> encodedArrays = new ArrayList();
    private @UnknownKeyFor @NonNull @Initialized int firstArrayPosition = 0;

    public OrderedCode() {
    }

    public OrderedCode(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedByteArray) {
        this.encodedArrays.add(encodedByteArray);
    }

    public void writeBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
        this.writeBytes(value, false);
    }

    public void writeBytesDecreasing(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
        this.writeBytes(value, true);
    }

    private void writeBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized boolean invert) {
        int encodedLength = 2;
        for (byte b : value) {
            if (b == 0 || b == -1) {
                encodedLength += 2;
                continue;
            }
            ++encodedLength;
        }
        byte[] encodedArray = new byte[encodedLength];
        int copyStart = 0;
        int outIndex = 0;
        for (int i = 0; i < value.length; ++i) {
            byte b = value[i];
            if (b == 0) {
                this.arraycopy(invert, value, copyStart, encodedArray, outIndex, i - copyStart);
                outIndex += i - copyStart;
                encodedArray[outIndex++] = OrderedCode.convert(invert, (byte)0);
                encodedArray[outIndex++] = OrderedCode.convert(invert, (byte)-1);
                copyStart = i + 1;
                continue;
            }
            if (b != -1) continue;
            this.arraycopy(invert, value, copyStart, encodedArray, outIndex, i - copyStart);
            outIndex += i - copyStart;
            encodedArray[outIndex++] = OrderedCode.convert(invert, (byte)-1);
            encodedArray[outIndex++] = OrderedCode.convert(invert, (byte)0);
            copyStart = i + 1;
        }
        if (copyStart < value.length) {
            this.arraycopy(invert, value, copyStart, encodedArray, outIndex, value.length - copyStart);
            outIndex += value.length - copyStart;
        }
        encodedArray[outIndex++] = OrderedCode.convert(invert, (byte)0);
        encodedArray[outIndex] = OrderedCode.convert(invert, (byte)1);
        this.encodedArrays.add(encodedArray);
    }

    private static @UnknownKeyFor @NonNull @Initialized byte convert(@UnknownKeyFor @NonNull @Initialized boolean invert, @UnknownKeyFor @NonNull @Initialized byte val) {
        return invert ? (byte)(~val) : val;
    }

    private static @UnknownKeyFor @NonNull @Initialized byte invert(@UnknownKeyFor @NonNull @Initialized byte val) {
        return OrderedCode.convert(true, val);
    }

    private void arraycopy(@UnknownKeyFor @NonNull @Initialized boolean invert, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] src, @UnknownKeyFor @NonNull @Initialized int srcPos, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dest, @UnknownKeyFor @NonNull @Initialized int destPos, @UnknownKeyFor @NonNull @Initialized int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        if (invert) {
            for (int i = destPos; i < destPos + length; ++i) {
                dest[i] = ~dest[i];
            }
        }
    }

    public void writeNumIncreasing(@UnknownKeyFor @NonNull @Initialized long value) {
        byte[] bufer = new byte[9];
        int len = 0;
        while (value != 0L) {
            bufer[9 - ++len] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        bufer[9 - len - 1] = (byte)len;
        byte[] encodedArray = new byte[++len];
        System.arraycopy(bufer, 9 - len, encodedArray, 0, len);
        this.encodedArrays.add(encodedArray);
    }

    public void writeNumIncreasing(@UnknownKeyFor @NonNull @Initialized UnsignedInteger unsignedInt) {
        this.writeNumIncreasing(unsignedInt.longValue());
    }

    public void writeNumDecreasing(@UnknownKeyFor @NonNull @Initialized long value) {
        byte[] bufer = new byte[9];
        int len = 0;
        while (value != 0L) {
            bufer[9 - ++len] = (byte)(value & 0xFFL ^ 0xFFFFFFFFFFFFFFFFL);
            value >>>= 8;
        }
        bufer[9 - len - 1] = (byte)(~len);
        byte[] encodedArray = new byte[++len];
        System.arraycopy(bufer, 9 - len, encodedArray, 0, len);
        this.encodedArrays.add(encodedArray);
    }

    public void writeNumDecreasing(@UnknownKeyFor @NonNull @Initialized UnsignedInteger unsignedInt) {
        this.writeNumDecreasing(unsignedInt.longValue());
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized int log2Floor(@UnknownKeyFor @NonNull @Initialized long n) {
        Preconditions.checkArgument((n >= 0L ? 1 : 0) != 0);
        return n == 0L ? -1 : LongMath.log2((long)n, (RoundingMode)RoundingMode.FLOOR);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized int getSignedEncodingLength(@UnknownKeyFor @NonNull @Initialized long n) {
        return BITS_TO_LENGTH[this.log2Floor(n < 0L ? n ^ 0xFFFFFFFFFFFFFFFFL : n) + 1];
    }

    public void writeSignedNumIncreasing(@UnknownKeyFor @NonNull @Initialized long val) {
        int beginIndex;
        long x;
        long l = x = val < 0L ? val ^ 0xFFFFFFFFFFFFFFFFL : val;
        if (x < 64L) {
            byte[] encodedArray = new byte[]{(byte)((long)LENGTH_TO_HEADER_BITS[1][0] ^ val)};
            this.encodedArrays.add(encodedArray);
            return;
        }
        int signByte = val < 0L ? -1 : 0;
        byte[] buf = new byte[10];
        buf[0] = buf[1] = signByte;
        System.arraycopy(Longs.toByteArray((long)val), 0, buf, 2, 8);
        int len = this.getSignedEncodingLength(x);
        if (len < 2) {
            throw new IllegalStateException("Invalid length (" + len + ") returned by getSignedEncodingLength(" + x + ")");
        }
        int n = beginIndex = buf.length - len;
        buf[n] = (byte)(buf[n] ^ LENGTH_TO_HEADER_BITS[len][0]);
        int n2 = beginIndex + 1;
        buf[n2] = (byte)(buf[n2] ^ LENGTH_TO_HEADER_BITS[len][1]);
        byte[] encodedArray = new byte[len];
        System.arraycopy(buf, beginIndex, encodedArray, 0, len);
        this.encodedArrays.add(encodedArray);
    }

    public void writeSignedNumDecreasing(@UnknownKeyFor @NonNull @Initialized long val) {
        this.writeSignedNumIncreasing(val ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void writeInfinity() {
        this.writeTrailingBytes(INFINITY_ENCODED);
    }

    public void writeInfinityDecreasing() {
        this.writeTrailingBytes(INFINITY_ENCODED_DECREASING);
    }

    public void writeTrailingBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException("Value cannot be null or have 0 elements");
        }
        this.encodedArrays.add(value);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readBytes() {
        return this.readBytes(false);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readBytesDecreasing() {
        return this.readBytes(true);
    }

    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readBytes(@UnknownKeyFor @NonNull @Initialized boolean invert) {
        if (this.encodedArrays.isEmpty() || this.encodedArrays.get(0).length - this.firstArrayPosition <= 0) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] store = this.encodedArrays.get(0);
        int decodedLength = 0;
        boolean valid = false;
        int i = this.firstArrayPosition;
        while (i < store.length - 1) {
            byte b;
            if ((b = store[i++]) == OrderedCode.convert(invert, (byte)0)) {
                if ((b = store[i++]) == OrderedCode.convert(invert, (byte)1)) {
                    valid = true;
                    break;
                }
                if (b == OrderedCode.convert(invert, (byte)-1)) {
                    ++decodedLength;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
            if (b == OrderedCode.convert(invert, (byte)-1)) {
                if ((b = store[i++]) == OrderedCode.convert(invert, (byte)0)) {
                    ++decodedLength;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
            ++decodedLength;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] decodedArray = new byte[decodedLength];
        int copyStart = this.firstArrayPosition;
        int outIndex = 0;
        int j = this.firstArrayPosition;
        while (j < store.length - 1) {
            byte b;
            if ((b = store[j++]) == OrderedCode.convert(invert, (byte)0)) {
                this.arraycopy(invert, store, copyStart, decodedArray, outIndex, j - copyStart - 1);
                outIndex += j - copyStart - 1;
                b = store[j++];
                if (b == OrderedCode.convert(invert, (byte)1)) {
                    if (store.length - j == 0) {
                        this.encodedArrays.remove(0);
                        this.firstArrayPosition = 0;
                    } else {
                        this.firstArrayPosition = j;
                    }
                    return decodedArray;
                }
                if (b == OrderedCode.convert(invert, (byte)-1)) {
                    decodedArray[outIndex++] = 0;
                }
                copyStart = j;
                continue;
            }
            if (b != OrderedCode.convert(invert, (byte)-1)) continue;
            this.arraycopy(invert, store, copyStart, decodedArray, outIndex, j - copyStart - 1);
            outIndex += j - copyStart - 1;
            b = store[j++];
            if (b == OrderedCode.convert(invert, (byte)0)) {
                decodedArray[outIndex++] = -1;
            }
            copyStart = j;
        }
        throw new IllegalArgumentException("Invalid encoded byte array");
    }

    public @UnknownKeyFor @NonNull @Initialized long readNumIncreasing() {
        if (this.encodedArrays.isEmpty() || this.encodedArrays.get(0).length - this.firstArrayPosition < 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] store = this.encodedArrays.get(0);
        int len = store[this.firstArrayPosition];
        if (this.firstArrayPosition + len + 1 > store.length || len > 8) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        long result = 0L;
        for (int i = 0; i < len; ++i) {
            result <<= 8;
            result |= (long)(store[this.firstArrayPosition + i + 1] & 0xFF);
        }
        if (store.length - this.firstArrayPosition - len - 1 == 0) {
            this.encodedArrays.remove(0);
            this.firstArrayPosition = 0;
        } else {
            this.firstArrayPosition = this.firstArrayPosition + len + 1;
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized long readNumDecreasing() {
        if (this.encodedArrays.isEmpty() || this.encodedArrays.get(0).length - this.firstArrayPosition < 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] store = this.encodedArrays.get(0);
        int len = ~store[this.firstArrayPosition] & 0xFF;
        if (this.firstArrayPosition + len + 1 > store.length || len > 8) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        long result = 0L;
        for (int i = 0; i < len; ++i) {
            result <<= 8;
            result |= (long)(~store[this.firstArrayPosition + i + 1] & 0xFF);
        }
        if (store.length - this.firstArrayPosition - len - 1 == 0) {
            this.encodedArrays.remove(0);
            this.firstArrayPosition = 0;
        } else {
            this.firstArrayPosition = this.firstArrayPosition + len + 1;
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized long readSignedNumIncreasing() {
        long x;
        int len;
        byte[] store;
        if (this.encodedArrays.isEmpty() || this.encodedArrays.get(0).length - this.firstArrayPosition < 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        long xorMask = ((store = this.encodedArrays.get(0))[this.firstArrayPosition] & 0x80) == 0 ? -1L : 0L;
        int firstByte = store[this.firstArrayPosition] & 0xFF ^ (int)(xorMask & 0xFFL);
        if (firstByte != 255) {
            len = 7 - this.log2Floor(firstByte ^ 0xFF);
            if (store.length - this.firstArrayPosition < len) {
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
            x = xorMask;
            for (int i = this.firstArrayPosition; i < this.firstArrayPosition + len; ++i) {
                x = x << 8 | (long)(store[i] & 0xFF);
            }
        } else {
            len = 8;
            if (store.length - this.firstArrayPosition < len) {
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
            int secondByte = store[this.firstArrayPosition + 1] & 0xFF ^ (int)(xorMask & 0xFFL);
            if (secondByte >= 128) {
                if (secondByte < 192) {
                    len = 9;
                } else {
                    int thirdByte = store[this.firstArrayPosition + 2] & 0xFF ^ (int)(xorMask & 0xFFL);
                    if (secondByte == 192 && thirdByte < 128) {
                        len = 10;
                    } else {
                        throw new IllegalArgumentException("Invalid encoded byte array");
                    }
                }
                if (store.length - this.firstArrayPosition < len) {
                    throw new IllegalArgumentException("Invalid encoded byte array");
                }
            }
            x = Longs.fromByteArray((byte[])Arrays.copyOfRange(store, this.firstArrayPosition + len - 8, this.firstArrayPosition + len));
        }
        if (len != this.getSignedEncodingLength(x ^= LENGTH_TO_MASK[len])) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        if (store.length - this.firstArrayPosition - len == 0) {
            this.encodedArrays.remove(0);
            this.firstArrayPosition = 0;
        } else {
            this.firstArrayPosition += len;
        }
        return x;
    }

    public @UnknownKeyFor @NonNull @Initialized long readSignedNumDecreasing() {
        return this.readSignedNumIncreasing() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean readInfinity() {
        return this.readInfinityInternal(INFINITY_ENCODED);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean readInfinityDecreasing() {
        return this.readInfinityInternal(INFINITY_ENCODED_DECREASING);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean readInfinityInternal(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] codes) {
        if (this.encodedArrays.isEmpty() || this.encodedArrays.get(0).length - this.firstArrayPosition < 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] store = this.encodedArrays.get(0);
        if (store.length - this.firstArrayPosition < 2) {
            return false;
        }
        if (store[this.firstArrayPosition] == codes[0] && store[this.firstArrayPosition + 1] == codes[1]) {
            if (store.length - this.firstArrayPosition - 2 == 0) {
                this.encodedArrays.remove(0);
                this.firstArrayPosition = 0;
            } else {
                this.firstArrayPosition += 2;
            }
            return true;
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readTrailingBytes() {
        if (this.encodedArrays.size() != 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        byte[] store = this.encodedArrays.get(0);
        this.encodedArrays.remove(0);
        assert (this.encodedArrays.isEmpty());
        return Arrays.copyOfRange(store, this.firstArrayPosition, store.length);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getEncodedBytes() {
        if (this.encodedArrays.isEmpty()) {
            return new byte[0];
        }
        if (this.encodedArrays.size() == 1 && this.firstArrayPosition == 0) {
            return this.encodedArrays.get(0);
        }
        int totalLength = 0;
        for (int i = 0; i < this.encodedArrays.size(); ++i) {
            byte[] bytes = this.encodedArrays.get(i);
            if (i == 0) {
                totalLength += bytes.length - this.firstArrayPosition;
                continue;
            }
            totalLength += bytes.length;
        }
        byte[] encodedBytes = new byte[totalLength];
        int destPos = 0;
        for (int i = 0; i < this.encodedArrays.size(); ++i) {
            byte[] bytes = this.encodedArrays.get(i);
            if (i == 0) {
                System.arraycopy(bytes, this.firstArrayPosition, encodedBytes, destPos, bytes.length - this.firstArrayPosition);
                destPos += bytes.length - this.firstArrayPosition;
                continue;
            }
            System.arraycopy(bytes, 0, encodedBytes, destPos, bytes.length);
            destPos += bytes.length;
        }
        this.encodedArrays.clear();
        this.encodedArrays.add(encodedBytes);
        this.firstArrayPosition = 0;
        return encodedBytes;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasRemainingEncodedBytes() {
        return this.encodedArrays.size() != 0;
    }
}

