/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_PubsubWriteSchemaTransformConfiguration
extends PubsubWriteSchemaTransformConfiguration {
    private final String format;
    private final String topic;
    private final List<String> attributes;
    private final String attributesMap;
    private final String idAttribute;
    private final String timestampAttribute;
    private final PubsubWriteSchemaTransformConfiguration.ErrorHandling errorHandling;

    private AutoValue_PubsubWriteSchemaTransformConfiguration(String format, String topic, @Nullable List<String> attributes, @Nullable String attributesMap, @Nullable String idAttribute, @Nullable String timestampAttribute, @Nullable PubsubWriteSchemaTransformConfiguration.ErrorHandling errorHandling) {
        this.format = format;
        this.topic = topic;
        this.attributes = attributes;
        this.attributesMap = attributesMap;
        this.idAttribute = idAttribute;
        this.timestampAttribute = timestampAttribute;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: RAW,AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The name of the topic to write data to. Format: projects/${PROJECT}/topics/${TOPIC}")
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The set of fields to write as PubSub attributes instead of part of the payload.")
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="A map field to write as PubSub attributes instead of part of the payload.")
    public String getAttributesMap() {
        return this.attributesMap;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="If set, will set an attribute for each Cloud Pub/Sub message with the given name and a unique value. This attribute can then be used in a ReadFromPubSub PTransform to deduplicate messages.")
    public String getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="If set, will set an attribute for each Cloud Pub/Sub message with the given name and the message's publish time as the value.")
    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies how to handle errors.")
    public PubsubWriteSchemaTransformConfiguration.ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "PubsubWriteSchemaTransformConfiguration{format=" + this.format + ", topic=" + this.topic + ", attributes=" + this.attributes + ", attributesMap=" + this.attributesMap + ", idAttribute=" + this.idAttribute + ", timestampAttribute=" + this.timestampAttribute + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubWriteSchemaTransformConfiguration) {
            PubsubWriteSchemaTransformConfiguration that = (PubsubWriteSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.topic.equals(that.getTopic()) && (this.attributes == null ? that.getAttributes() == null : this.attributes.equals(that.getAttributes())) && (this.attributesMap == null ? that.getAttributesMap() == null : this.attributesMap.equals(that.getAttributesMap())) && (this.idAttribute == null ? that.getIdAttribute() == null : this.idAttribute.equals(that.getIdAttribute())) && (this.timestampAttribute == null ? that.getTimestampAttribute() == null : this.timestampAttribute.equals(that.getTimestampAttribute())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes == null ? 0 : this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributesMap == null ? 0 : this.attributesMap.hashCode();
        h$ *= 1000003;
        h$ ^= this.idAttribute == null ? 0 : this.idAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampAttribute == null ? 0 : this.timestampAttribute.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends PubsubWriteSchemaTransformConfiguration.Builder {
        private String format;
        private String topic;
        private List<String> attributes;
        private String attributesMap;
        private String idAttribute;
        private String timestampAttribute;
        private PubsubWriteSchemaTransformConfiguration.ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setAttributes(@Nullable List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setAttributesMap(@Nullable String attributesMap) {
            this.attributesMap = attributesMap;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setIdAttribute(@Nullable String idAttribute) {
            this.idAttribute = idAttribute;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setTimestampAttribute(@Nullable String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setErrorHandling(@Nullable PubsubWriteSchemaTransformConfiguration.ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration build() {
            if (this.format == null || this.topic == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.topic == null) {
                    missing.append(" topic");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubWriteSchemaTransformConfiguration(this.format, this.topic, this.attributes, this.attributesMap, this.idAttribute, this.timestampAttribute, this.errorHandling);
        }
    }
}

