/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubTestClient
extends PubsubClient
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized State STATE = new State();

    public static @UnknownKeyFor @NonNull @Initialized PubsubTestClientFactory createFactoryForPublish(@Nullable @UnknownKeyFor @Initialized PubsubClient.TopicPath expectedTopic, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> expectedOutgoingMessages, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> failingOutgoingMessages) {
        PubsubTestClient.activate(() -> PubsubTestClient.setPublishState(expectedTopic, expectedOutgoingMessages, failingOutgoingMessages));
        return new PubsubTestClientFactory(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options, @Nullable @UnknownKeyFor @Initialized String rootUrlOverride) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.newClient(timestampAttribute, idAttribute, options);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new PubsubTestClient();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getKind() {
                return "PublishTest";
            }

            @Override
            public void close() {
                PubsubTestClient.deactivate(() -> PubsubTestClient.performFinalPublishStateChecks());
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubTestClientFactory createFactoryForPull(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath expectedSubscription, @UnknownKeyFor @NonNull @Initialized int ackTimeoutSec, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> expectedIncomingMessages) {
        PubsubTestClient.activate(() -> PubsubTestClient.setPullState(expectedSubscription, clock, ackTimeoutSec, expectedIncomingMessages));
        return new PubsubTestClientFactory(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options, @Nullable @UnknownKeyFor @Initialized String rootUrlOverride) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.newClient(timestampAttribute, idAttribute, options);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new PubsubTestClient();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getKind() {
                return "PullTest";
            }

            @Override
            public void close() {
                PubsubTestClient.deactivate(() -> PubsubTestClient.performFinalPullStateChecks());
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubTestClientFactory createFactoryForPullAndPublish(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath pullSubscription, @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath publishTopicPath, @UnknownKeyFor @NonNull @Initialized Clock pullClock, @UnknownKeyFor @NonNull @Initialized int pullAckTimeoutSec, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> expectedIncomingMessages, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> expectedOutgoingMessages, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> failingOutgoingMessages) {
        PubsubTestClient.activate(() -> {
            PubsubTestClient.setPublishState(publishTopicPath, expectedOutgoingMessages, failingOutgoingMessages);
            PubsubTestClient.setPullState(pullSubscription, pullClock, pullAckTimeoutSec, expectedIncomingMessages);
        });
        return new PubsubTestClientFactory(){

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                PubsubTestClient.deactivate(() -> {
                    PubsubTestClient.performFinalPublishStateChecks();
                    PubsubTestClient.performFinalPullStateChecks();
                });
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options, @Nullable @UnknownKeyFor @Initialized String rootUrlOverride) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.newClient(timestampAttribute, idAttribute, options);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new PubsubTestClient();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getKind() {
                return "PublishAndPullTest";
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubTestClientFactory createFactoryForGetSchema(final @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath expectedTopic, final @Nullable @UnknownKeyFor @Initialized PubsubClient.SchemaPath expectedSchemaPath, final @Nullable @UnknownKeyFor @Initialized Schema expectedSchema) {
        return new PubsubTestClientFactory(){

            @Override
            public void close() {
                PubsubTestClient.deactivate(() -> {});
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options, @Nullable @UnknownKeyFor @Initialized String rootUrlOverride) {
                PubsubTestClient.activate(() -> PubsubTestClient.setSchemaState(expectedTopic, expectedSchemaPath, expectedSchema));
                return new PubsubTestClient();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.newClient(timestampAttribute, idAttribute, options, null);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getKind() {
                return "GetSchemaTest";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activate(@UnknownKeyFor @NonNull @Initialized Runnable setStateValues) {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((!PubsubTestClient.STATE.isActive ? 1 : 0) != 0, (Object)"Test still in flight");
            setStateValues.run();
            PubsubTestClient.STATE.isActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deactivate(@UnknownKeyFor @NonNull @Initialized Runnable runFinalChecks) {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test still in flight");
            runFinalChecks.run();
            PubsubTestClient.STATE.remainingExpectedOutgoingMessages = null;
            PubsubTestClient.STATE.remainingPendingIncomingMessages = null;
            PubsubTestClient.STATE.pendingAckIncomingMessages = null;
            PubsubTestClient.STATE.ackDeadline = null;
            PubsubTestClient.STATE.isActive = false;
        }
    }

    private static void setPublishState(@Nullable @UnknownKeyFor @Initialized PubsubClient.TopicPath expectedTopic, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> expectedOutgoingMessages, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> failingOutgoingMessages) {
        PubsubTestClient.STATE.isPublish = true;
        PubsubTestClient.STATE.expectedTopic = expectedTopic;
        PubsubTestClient.STATE.remainingExpectedOutgoingMessages = Sets.newHashSet(expectedOutgoingMessages);
        PubsubTestClient.STATE.remainingFailingOutgoingMessages = Sets.newHashSet(failingOutgoingMessages);
    }

    private static void setPullState(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath expectedSubscription, @UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized int ackTimeoutSec, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> expectedIncomingMessages) {
        PubsubTestClient.STATE.clock = clock;
        PubsubTestClient.STATE.expectedSubscription = expectedSubscription;
        PubsubTestClient.STATE.ackTimeoutSec = ackTimeoutSec;
        PubsubTestClient.STATE.remainingPendingIncomingMessages = Lists.newArrayList(expectedIncomingMessages);
        PubsubTestClient.STATE.pendingAckIncomingMessages = new HashMap<String, PubsubClient.IncomingMessage>();
        PubsubTestClient.STATE.ackDeadline = new HashMap<String, Long>();
    }

    private static void setSchemaState(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath expectedTopic, @Nullable @UnknownKeyFor @Initialized PubsubClient.SchemaPath expectedSchemaPath, @Nullable @UnknownKeyFor @Initialized Schema expectedSchema) {
        PubsubTestClient.STATE.expectedTopic = expectedTopic;
        PubsubTestClient.STATE.expectedSchemaPath = expectedSchemaPath;
        PubsubTestClient.STATE.expectedSchema = expectedSchema;
    }

    private static void performFinalPublishStateChecks() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test still in flight");
        Preconditions.checkState((boolean)PubsubTestClient.STATE.remainingExpectedOutgoingMessages.isEmpty(), (String)"Still waiting for %s messages to be published", (int)PubsubTestClient.STATE.remainingExpectedOutgoingMessages.size());
    }

    private static void performFinalPullStateChecks() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.remainingPendingIncomingMessages.isEmpty(), (String)"Still waiting for %s messages to be pulled", (int)PubsubTestClient.STATE.remainingPendingIncomingMessages.size());
        Preconditions.checkState((boolean)PubsubTestClient.STATE.pendingAckIncomingMessages.isEmpty(), (String)"Still waiting for %s messages to be ACKed", (int)PubsubTestClient.STATE.pendingAckIncomingMessages.size());
        Preconditions.checkState((boolean)PubsubTestClient.STATE.ackDeadline.isEmpty(), (String)"Still waiting for %s messages to be ACKed", (int)PubsubTestClient.STATE.ackDeadline.size());
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubTestClientFactory createFactoryForCreateSubscription() {
        return new PubsubTestClientFactory(){
            @UnknownKeyFor @NonNull @Initialized int numCalls = 0;

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                Preconditions.checkState((this.numCalls == 1 ? 1 : 0) != 0, (String)"Expected exactly one subscription to be created, got %s", (int)this.numCalls);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options, @Nullable @UnknownKeyFor @Initialized String rootUrlOverride) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.newClient(timestampAttribute, idAttribute, options);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new PubsubTestClient(){

                    @Override
                    public void createSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
                        Preconditions.checkState((numCalls == 0 ? 1 : 0) != 0, (Object)"Expected at most one subscription to be created");
                        ++numCalls;
                    }
                };
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getKind() {
                return "CreateSubscriptionTest";
            }
        };
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inPullMode() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test is active");
        return PubsubTestClient.STATE.expectedSubscription != null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inPublishMode() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test is active");
        return PubsubTestClient.STATE.isPublish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advance() {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only advance in pull mode");
            Iterator<Map.Entry<String, Long>> deadlineItr = PubsubTestClient.STATE.ackDeadline.entrySet().iterator();
            while (deadlineItr.hasNext()) {
                Map.Entry<String, Long> entry = deadlineItr.next();
                if (entry.getValue() > PubsubTestClient.STATE.clock.currentTimeMillis()) continue;
                PubsubTestClient.STATE.remainingPendingIncomingMessages.add(PubsubTestClient.STATE.pendingAckIncomingMessages.remove(entry.getKey()));
                deadlineItr.remove();
            }
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized int publish(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> outgoingMessages) throws @UnknownKeyFor @NonNull @Initialized IOException {
        State state = STATE;
        synchronized (state) {
            boolean isDynamic;
            Preconditions.checkState((boolean)this.inPublishMode(), (Object)"Can only publish in publish mode");
            boolean bl = isDynamic = PubsubTestClient.STATE.expectedTopic == null;
            if (!isDynamic) {
                Preconditions.checkState((boolean)topic.equals(PubsubTestClient.STATE.expectedTopic), (String)"Topic %s does not match expected %s", (Object)topic, (Object)PubsubTestClient.STATE.expectedTopic);
            }
            for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
                if (isDynamic) {
                    Preconditions.checkState((boolean)outgoingMessage.topic().equals(topic.getPath()));
                } else {
                    Preconditions.checkState((outgoingMessage.topic() == null ? 1 : 0) != 0);
                }
                if (PubsubTestClient.STATE.remainingFailingOutgoingMessages.remove(outgoingMessage)) {
                    throw new RuntimeException("Simulating failure for " + outgoingMessage);
                }
                Preconditions.checkState((boolean)PubsubTestClient.STATE.remainingExpectedOutgoingMessages.remove(outgoingMessage), (String)"Unexpected outgoing message %s", (Object)outgoingMessage);
            }
            return outgoingMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> pull(@UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int batchSize, @UnknownKeyFor @NonNull @Initialized boolean returnImmediately) throws @UnknownKeyFor @NonNull @Initialized IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only pull in pull mode");
            long now = PubsubTestClient.STATE.clock.currentTimeMillis();
            Preconditions.checkState((requestTimeMsSinceEpoch == now ? 1 : 0) != 0, (String)"Simulated time %s does not match request time %s", (long)now, (long)requestTimeMsSinceEpoch);
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            Preconditions.checkState((boolean)returnImmediately, (Object)"Pull only supported if returning immediately");
            ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>();
            Iterator<PubsubClient.IncomingMessage> pendItr = PubsubTestClient.STATE.remainingPendingIncomingMessages.iterator();
            while (pendItr.hasNext()) {
                PubsubClient.IncomingMessage incomingMessage = pendItr.next();
                pendItr.remove();
                PubsubClient.IncomingMessage incomingMessageWithRequestTime = PubsubClient.IncomingMessage.of(incomingMessage.message(), incomingMessage.timestampMsSinceEpoch(), requestTimeMsSinceEpoch, incomingMessage.ackId(), incomingMessage.recordId());
                incomingMessages.add(incomingMessageWithRequestTime);
                PubsubTestClient.STATE.pendingAckIncomingMessages.put(incomingMessageWithRequestTime.ackId(), incomingMessageWithRequestTime);
                PubsubTestClient.STATE.ackDeadline.put(incomingMessageWithRequestTime.ackId(), requestTimeMsSinceEpoch + (long)(PubsubTestClient.STATE.ackTimeoutSec * 1000));
                if (incomingMessages.size() < batchSize) continue;
                break;
            }
            return incomingMessages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only acknowledge in pull mode");
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            for (String ackId : ackIds) {
                Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                Preconditions.checkState((PubsubTestClient.STATE.pendingAckIncomingMessages.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAckDeadline(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds, @UnknownKeyFor @NonNull @Initialized int deadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only modify ack deadline in pull mode");
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            for (String ackId : ackIds) {
                if (deadlineSeconds > 0) {
                    Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                    Preconditions.checkState((boolean)PubsubTestClient.STATE.pendingAckIncomingMessages.containsKey(ackId), (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                    PubsubTestClient.STATE.ackDeadline.put(ackId, PubsubTestClient.STATE.clock.currentTimeMillis() + (long)(deadlineSeconds * 1000));
                    continue;
                }
                Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                PubsubClient.IncomingMessage message = PubsubTestClient.STATE.pendingAckIncomingMessages.remove(ackId);
                Preconditions.checkState((message != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                PubsubTestClient.STATE.remainingPendingIncomingMessages.add(message);
            }
        }
    }

    @Override
    public void createTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized PubsubClient.SchemaPath schema) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath> listTopics(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTopicExists(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return true;
    }

    @Override
    public void createSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath> listSubscriptions(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project, @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        State state = STATE;
        synchronized (state) {
            return PubsubTestClient.STATE.ackTimeoutSec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isEOF() {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only check EOF in pull mode");
            return PubsubTestClient.STATE.remainingPendingIncomingMessages.isEmpty();
        }
    }

    @Override
    public void createSchema(@UnknownKeyFor @NonNull @Initialized PubsubClient.SchemaPath schemaPath, @UnknownKeyFor @NonNull @Initialized String schemaContent, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.Type type) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteSchema(@UnknownKeyFor @NonNull @Initialized PubsubClient.SchemaPath schemaPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PubsubClient.SchemaPath getSchemaPath(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topicPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return PubsubTestClient.STATE.expectedSchemaPath;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema getSchema(@UnknownKeyFor @NonNull @Initialized PubsubClient.SchemaPath schemaPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return PubsubTestClient.STATE.expectedSchema;
    }

    public static interface PubsubTestClientFactory
    extends PubsubClient.PubsubClientFactory,
    Closeable,
    Serializable {
        default public <T>  @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<T> setClock( @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<T> readTransform, @UnknownKeyFor @NonNull @Initialized Clock clock) {
            return readTransform.withClock(clock);
        }
    }

    private static class State {
        @UnknownKeyFor @NonNull @Initialized boolean isActive;
        @UnknownKeyFor @NonNull @Initialized boolean isPublish;
        @Nullable @UnknownKeyFor @Initialized PubsubClient.TopicPath expectedTopic;
        @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> remainingExpectedOutgoingMessages;
        @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> remainingFailingOutgoingMessages;
        @Nullable @UnknownKeyFor @Initialized Clock clock;
        @Nullable @UnknownKeyFor @Initialized PubsubClient.SubscriptionPath expectedSubscription;
        @UnknownKeyFor @NonNull @Initialized int ackTimeoutSec;
        @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> remainingPendingIncomingMessages;
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> pendingAckIncomingMessages;
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> ackDeadline;
        @Nullable @UnknownKeyFor @Initialized PubsubClient.SchemaPath expectedSchemaPath;
        @Nullable @UnknownKeyFor @Initialized Schema expectedSchema;

        private State() {
        }
    }
}

