/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessages;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={ExternalTransformRegistrar.class})
public final class ExternalWrite
implements ExternalTransformRegistrar {
    public static final @UnknownKeyFor @NonNull @Initialized String URN = "beam:transform:org.apache.beam:pubsub_write:v1";

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> knownBuilders() {
        return ImmutableMap.of((Object)URN, WriteBuilder.class);
    }

    public static class ParsePubsubMessageProtoAsPayloadFromWindowedValue
    implements SerializableFunction<ValueInSingleWindow<byte[]>, PubsubMessage> {
        static final  @UnknownKeyFor @NonNull @Initialized PubsubMessages.ParsePubsubMessageProtoAsPayload INNER = new PubsubMessages.ParsePubsubMessageProtoAsPayload();

        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
            return INNER.apply((byte[])input.getValue());
        }
    }

    public static class WriteBuilder
    implements ExternalTransformBuilder<Configuration, PCollection<byte[]>, PDone> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized PDone> buildExternal(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            PubsubIO.Write.Builder<byte[]> writeBuilder = PubsubIO.Write.newBuilder(new ParsePubsubMessageProtoAsPayloadFromWindowedValue());
            if (config.topic != null) {
                ValueProvider.StaticValueProvider topic = ValueProvider.StaticValueProvider.of((Object)config.topic);
                writeBuilder.setTopicProvider((ValueProvider<PubsubIO.PubsubTopic>)ValueProvider.NestedValueProvider.of((ValueProvider)topic, PubsubIO.PubsubTopic::fromPath));
            }
            if (config.idAttribute != null) {
                writeBuilder.setIdAttribute(config.idAttribute);
            }
            if (config.timestampAttribute != null) {
                writeBuilder.setTimestampAttribute(config.timestampAttribute);
            }
            writeBuilder.setDynamicDestinations(false);
            return writeBuilder.build();
        }
    }

    public static class Configuration {
        private @UnknownKeyFor @NonNull @Initialized String topic;
        private @Nullable @UnknownKeyFor @Initialized String idAttribute;
        private @Nullable @UnknownKeyFor @Initialized String timestampAttribute;

        public void setTopic(@UnknownKeyFor @NonNull @Initialized String topic) {
            this.topic = topic;
        }

        public void setIdLabel(@Nullable @UnknownKeyFor @Initialized String idAttribute) {
            this.idAttribute = idAttribute;
        }

        public void setTimestampAttribute(@Nullable @UnknownKeyFor @Initialized String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
        }
    }
}

