/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.LocalTime;

public final class CivilTimeEncoder {
    private static final @UnknownKeyFor @NonNull @Initialized int NANO_LENGTH = 30;
    private static final @UnknownKeyFor @NonNull @Initialized int MICRO_LENGTH = 20;
    private static final @UnknownKeyFor @NonNull @Initialized int NANO_SHIFT = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int MICRO_SHIFT = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int SECOND_SHIFT = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int MINUTE_SHIFT = 6;
    private static final @UnknownKeyFor @NonNull @Initialized int HOUR_SHIFT = 12;
    private static final @UnknownKeyFor @NonNull @Initialized int DAY_SHIFT = 17;
    private static final @UnknownKeyFor @NonNull @Initialized int MONTH_SHIFT = 22;
    private static final @UnknownKeyFor @NonNull @Initialized int YEAR_SHIFT = 26;
    private static final @UnknownKeyFor @NonNull @Initialized long NANO_MASK = 0x3FFFFFFFL;
    private static final @UnknownKeyFor @NonNull @Initialized long MICRO_MASK = 1048575L;
    private static final @UnknownKeyFor @NonNull @Initialized long SECOND_MASK = 63L;
    private static final @UnknownKeyFor @NonNull @Initialized long MINUTE_MASK = 4032L;
    private static final @UnknownKeyFor @NonNull @Initialized long HOUR_MASK = 126976L;
    private static final @UnknownKeyFor @NonNull @Initialized long DAY_MASK = 0x3E0000L;
    private static final @UnknownKeyFor @NonNull @Initialized long MONTH_MASK = 0x3C00000L;
    private static final @UnknownKeyFor @NonNull @Initialized long YEAR_MASK = 0xFFFC000000L;
    private static final @UnknownKeyFor @NonNull @Initialized long TIME_SECONDS_MASK = 131071L;
    private static final @UnknownKeyFor @NonNull @Initialized long TIME_MICROS_MASK = 0x1FFFFFFFFFL;
    private static final @UnknownKeyFor @NonNull @Initialized long TIME_NANOS_MASK = 0x7FFFFFFFFFFFL;
    private static final @UnknownKeyFor @NonNull @Initialized long DATETIME_SECONDS_MASK = 0xFFFFFFFFFFL;
    private static final @UnknownKeyFor @NonNull @Initialized long DATETIME_MICROS_MASK = 0xFFFFFFFFFFFFFFFL;

    public static @UnknownKeyFor @NonNull @Initialized int encodePacked32TimeSeconds(@UnknownKeyFor @NonNull @Initialized LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        int bitFieldTimeSeconds = 0;
        bitFieldTimeSeconds |= time.getHourOfDay() << 12;
        bitFieldTimeSeconds |= time.getMinuteOfHour() << 6;
        return bitFieldTimeSeconds |= time.getSecondOfMinute() << 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized int encodePacked32TimeSeconds(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        int bitFieldTimeSeconds = 0;
        bitFieldTimeSeconds |= time.getHour() << 12;
        bitFieldTimeSeconds |= time.getMinute() << 6;
        return bitFieldTimeSeconds |= time.getSecond() << 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized LocalTime decodePacked32TimeSeconds(@UnknownKeyFor @NonNull @Initialized int bitFieldTimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeSeconds, 131071L);
        int hourOfDay = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 126976L, 12);
        int minuteOfHour = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 4032L, 6);
        int secondOfMinute = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 63L, 0);
        LocalTime time = new LocalTime(hourOfDay, minuteOfHour, secondOfMinute);
        CivilTimeEncoder.checkValidTimeSeconds(time);
        return time;
    }

    public static @UnknownKeyFor @NonNull @Initialized java.time.LocalTime decodePacked32TimeSecondsAsJavaTime(@UnknownKeyFor @NonNull @Initialized int bitFieldTimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeSeconds, 131071L);
        int hourOfDay = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 126976L, 12);
        int minuteOfHour = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 4032L, 6);
        int secondOfMinute = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 63L, 0);
        try {
            return java.time.LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64TimeMicros(@UnknownKeyFor @NonNull @Initialized LocalTime time) {
        CivilTimeEncoder.checkValidTimeMillis(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 20 | (long)time.getMillisOfSecond() * 1000L;
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64TimeMicros(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeMicros(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 20 | (long)time.getNano() / 1000L;
    }

    public static @UnknownKeyFor @NonNull @Initialized LocalTime decodePacked64TimeMicros(@UnknownKeyFor @NonNull @Initialized long bitFieldTimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeMicros, 0x1FFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeMicros >> 20);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        LocalTime time = timeSeconds.withMillisOfSecond(microOfSecond / 1000);
        CivilTimeEncoder.checkValidTimeMillis(time);
        return time;
    }

    public static @UnknownKeyFor @NonNull @Initialized java.time.LocalTime decodePacked64TimeMicrosAsJavaTime(@UnknownKeyFor @NonNull @Initialized long bitFieldTimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeMicros, 0x1FFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeMicros >> 20);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        return timeSeconds.withNano(microOfSecond * 1000);
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64TimeNanos(@UnknownKeyFor @NonNull @Initialized LocalTime time) {
        CivilTimeEncoder.checkValidTimeMillis(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 30 | (long)time.getMillisOfSecond() * 1000000L;
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64TimeNanos(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeNanos(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 30 | (long)time.getNano();
    }

    public static @UnknownKeyFor @NonNull @Initialized LocalTime decodePacked64TimeNanos(@UnknownKeyFor @NonNull @Initialized long bitFieldTimeNanos) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeNanos, 0x7FFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeNanos >> 30);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int nanoOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeNanos, 0x3FFFFFFFL, 0);
        CivilTimeEncoder.checkValidNanoOfSecond(nanoOfSecond);
        LocalTime time = timeSeconds.withMillisOfSecond(nanoOfSecond / 1000000);
        CivilTimeEncoder.checkValidTimeMillis(time);
        return time;
    }

    public static @UnknownKeyFor @NonNull @Initialized java.time.LocalTime decodePacked64TimeNanosAsJavaTime(@UnknownKeyFor @NonNull @Initialized long bitFieldTimeNanos) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeNanos, 0x7FFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeNanos >> 30);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int nanoOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeNanos, 0x3FFFFFFFL, 0);
        CivilTimeEncoder.checkValidNanoOfSecond(nanoOfSecond);
        return timeSeconds.withNano(nanoOfSecond);
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64DatetimeSeconds(@UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        long bitFieldDatetimeSeconds = 0L;
        bitFieldDatetimeSeconds |= (long)dateTime.getYear() << 26;
        bitFieldDatetimeSeconds |= (long)dateTime.getMonthOfYear() << 22;
        bitFieldDatetimeSeconds |= (long)dateTime.getDayOfMonth() << 17;
        return bitFieldDatetimeSeconds |= (long)CivilTimeEncoder.encodePacked32TimeSeconds(dateTime.toLocalTime());
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64DatetimeSeconds(@UnknownKeyFor @NonNull @Initialized LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        long bitFieldDatetimeSeconds = 0L;
        bitFieldDatetimeSeconds |= (long)dateTime.getYear() << 26;
        bitFieldDatetimeSeconds |= (long)dateTime.getMonthValue() << 22;
        bitFieldDatetimeSeconds |= (long)dateTime.getDayOfMonth() << 17;
        return bitFieldDatetimeSeconds |= (long)CivilTimeEncoder.encodePacked32TimeSeconds(dateTime.toLocalTime());
    }

    public static @UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime decodePacked64DatetimeSeconds(@UnknownKeyFor @NonNull @Initialized long bitFieldDatetimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeSeconds, 0xFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldDatetimeSeconds & 0x1FFFFL);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int year = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0xFFFC000000L, 26);
        int monthOfYear = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3C00000L, 22);
        int dayOfMonth = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3E0000L, 17);
        org.joda.time.LocalDateTime dateTime = new org.joda.time.LocalDateTime(year, monthOfYear, dayOfMonth, timeSeconds.getHourOfDay(), timeSeconds.getMinuteOfHour(), timeSeconds.getSecondOfMinute());
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        return dateTime;
    }

    public static @UnknownKeyFor @NonNull @Initialized LocalDateTime decodePacked64DatetimeSecondsAsJavaTime(@UnknownKeyFor @NonNull @Initialized long bitFieldDatetimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeSeconds, 0xFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldDatetimeSeconds & 0x1FFFFL);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int year = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0xFFFC000000L, 26);
        int monthOfYear = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3C00000L, 22);
        int dayOfMonth = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3E0000L, 17);
        try {
            LocalDateTime dateTime = LocalDateTime.of(year, monthOfYear, dayOfMonth, timeSeconds.getHour(), timeSeconds.getMinute(), timeSeconds.getSecond());
            CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
            return dateTime;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64DatetimeMicros(@UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeMillis(dateTime);
        return CivilTimeEncoder.encodePacked64DatetimeSeconds(dateTime) << 20 | (long)dateTime.getMillisOfSecond() * 1000L;
    }

    public static @UnknownKeyFor @NonNull @Initialized long encodePacked64DatetimeMicros(@UnknownKeyFor @NonNull @Initialized LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return CivilTimeEncoder.encodePacked64DatetimeSeconds(dateTime) << 20 | (long)dateTime.getNano() / 1000L;
    }

    public static @UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime decodePacked64DatetimeMicros(@UnknownKeyFor @NonNull @Initialized long bitFieldDatetimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeMicros, 0xFFFFFFFFFFFFFFFL);
        long bitFieldDatetimeSeconds = bitFieldDatetimeMicros >> 20;
        org.joda.time.LocalDateTime dateTimeSeconds = CivilTimeEncoder.decodePacked64DatetimeSeconds(bitFieldDatetimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        org.joda.time.LocalDateTime dateTime = dateTimeSeconds.withMillisOfSecond(microOfSecond / 1000);
        CivilTimeEncoder.checkValidDateTimeMillis(dateTime);
        return dateTime;
    }

    public static @UnknownKeyFor @NonNull @Initialized LocalDateTime decodePacked64DatetimeMicrosAsJavaTime(@UnknownKeyFor @NonNull @Initialized long bitFieldDatetimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeMicros, 0xFFFFFFFFFFFFFFFL);
        long bitFieldDatetimeSeconds = bitFieldDatetimeMicros >> 20;
        LocalDateTime dateTimeSeconds = CivilTimeEncoder.decodePacked64DatetimeSecondsAsJavaTime(bitFieldDatetimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        LocalDateTime dateTime = dateTimeSeconds.withNano(microOfSecond * 1000);
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return dateTime;
    }

    private static @UnknownKeyFor @NonNull @Initialized int getFieldFromBitField(@UnknownKeyFor @NonNull @Initialized long bitField, @UnknownKeyFor @NonNull @Initialized long mask, @UnknownKeyFor @NonNull @Initialized int shift) {
        return (int)((bitField & mask) >> shift);
    }

    private static void checkValidTimeSeconds(@UnknownKeyFor @NonNull @Initialized LocalTime time) {
        Preconditions.checkArgument((time.getHourOfDay() >= 0 && time.getHourOfDay() <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getMinuteOfHour() >= 0 && time.getMinuteOfHour() <= 59 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getSecondOfMinute() >= 0 && time.getSecondOfMinute() <= 59 ? 1 : 0) != 0);
    }

    private static void checkValidTimeSeconds(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        Preconditions.checkArgument((time.getHour() >= 0 && time.getHour() <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getMinute() >= 0 && time.getMinute() <= 59 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getSecond() >= 0 && time.getSecond() <= 59 ? 1 : 0) != 0);
    }

    private static void checkValidTimeMillis(@UnknownKeyFor @NonNull @Initialized LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        Preconditions.checkArgument((time.getMillisOfSecond() >= 0 && time.getMillisOfSecond() <= 999 ? 1 : 0) != 0);
    }

    private static void checkValidTimeMicros(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        Preconditions.checkArgument((boolean)time.equals(time.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidTimeNanos(@UnknownKeyFor @NonNull @Initialized java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
    }

    private static void checkValidDateTimeSeconds(@UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime dateTime) {
        Preconditions.checkArgument((dateTime.getYear() >= 1 && dateTime.getYear() <= 9999 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getMonthOfYear() >= 1 && dateTime.getMonthOfYear() <= 12 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getDayOfMonth() >= 1 && dateTime.getDayOfMonth() <= 31 ? 1 : 0) != 0);
        CivilTimeEncoder.checkValidTimeSeconds(dateTime.toLocalTime());
    }

    private static void checkValidDateTimeSeconds(@UnknownKeyFor @NonNull @Initialized LocalDateTime dateTime) {
        Preconditions.checkArgument((dateTime.getYear() >= 1 && dateTime.getYear() <= 9999 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getMonthValue() >= 1 && dateTime.getMonthValue() <= 12 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getDayOfMonth() >= 1 && dateTime.getDayOfMonth() <= 31 ? 1 : 0) != 0);
        CivilTimeEncoder.checkValidTimeSeconds(dateTime.toLocalTime());
    }

    private static void checkValidDateTimeMillis(@UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        Preconditions.checkArgument((dateTime.getMillisOfSecond() >= 0 && dateTime.getMillisOfSecond() <= 999 ? 1 : 0) != 0);
    }

    private static void checkValidDateTimeMicros(@UnknownKeyFor @NonNull @Initialized LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        Preconditions.checkArgument((boolean)dateTime.equals(dateTime.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidMicroOfSecond(@UnknownKeyFor @NonNull @Initialized int microOfSecond) {
        Preconditions.checkArgument((microOfSecond >= 0 && microOfSecond <= 999999 ? 1 : 0) != 0);
    }

    private static void checkValidNanoOfSecond(@UnknownKeyFor @NonNull @Initialized int nanoOfSecond) {
        Preconditions.checkArgument((nanoOfSecond >= 0 && nanoOfSecond <= 999999999 ? 1 : 0) != 0);
    }

    private static void checkValidBitField(@UnknownKeyFor @NonNull @Initialized long bitField, @UnknownKeyFor @NonNull @Initialized long mask) {
        Preconditions.checkArgument(((bitField & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L ? 1 : 0) != 0);
    }

    private CivilTimeEncoder() {
    }
}

