/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubTestClient;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_PubsubReadSchemaTransformConfiguration
extends PubsubReadSchemaTransformConfiguration {
    private final String topic;
    private final String subscription;
    private final String format;
    private final String schema;
    private final List<String> attributes;
    private final String attributesMap;
    private final String idAttribute;
    private final String timestampAttribute;
    private final PubsubReadSchemaTransformConfiguration.ErrorHandling errorHandling;
    private final PubsubTestClient.PubsubTestClientFactory clientFactory;
    private final Clock clock;

    private AutoValue_PubsubReadSchemaTransformConfiguration(@Nullable String topic, @Nullable String subscription, String format, String schema, @Nullable List<String> attributes, @Nullable String attributesMap, @Nullable String idAttribute, @Nullable String timestampAttribute, @Nullable PubsubReadSchemaTransformConfiguration.ErrorHandling errorHandling, @Nullable PubsubTestClient.PubsubTestClientFactory clientFactory, @Nullable Clock clock) {
        this.topic = topic;
        this.subscription = subscription;
        this.format = format;
        this.schema = schema;
        this.attributes = attributes;
        this.attributesMap = attributesMap;
        this.idAttribute = idAttribute;
        this.timestampAttribute = timestampAttribute;
        this.errorHandling = errorHandling;
        this.clientFactory = clientFactory;
        this.clock = clock;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The name of the topic to consume data from. If a topic is specified,  will create a new subscription for that topic and start consuming from that point. Either a topic or a subscription must be provided. Format: projects/${PROJECT}/topics/${TOPIC}")
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The name of the subscription to consume data. Either a topic or subscription must be provided. Format: projects/${PROJECT}/subscriptions/${SUBSCRIPTION}")
    public String getSubscription() {
        return this.subscription;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: RAW,AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The schema in which the data is encoded in the Pubsub topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Any additional pubsub attributes that should be populated as String fields in the ouptut rows.")
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Any additional field that should be populated with the full set of PubSub attributes.")
    public String getAttributesMap() {
        return this.attributesMap;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="When reading from Cloud Pub/Sub where unique record identifiers are provided as Pub/Sub message attributes, specifies the name of the attribute containing the unique identifier. The value of the attribute can be any string that uniquely identifies this record. Pub/Sub cannot guarantee that no duplicate data will be delivered on the Pub/Sub stream. If idAttribute is not provided, Beam cannot guarantee that no duplicate data will be delivered, and deduplication of the stream will be strictly best effort.")
    public String getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the name of the attribute that contains the timestamp, if any. The timestamp value is expected to be represented in the attribute as either (1) a numerical value representing the number of milliseconds since the Unix epoch. For example, if using the Joda time classes, Instant.getMillis() returns the correct value for this attribute. or (2) a String in RFC 3339 format. For example, 2015-10-29T23:41:41.123Z. The sub-second component of the timestamp is optional, and digits beyond the first three (i.e., time units smaller than milliseconds) will be ignored.")
    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies how to handle errors.")
    public PubsubReadSchemaTransformConfiguration.ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    @Override
    @Nullable
    public PubsubTestClient.PubsubTestClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Nullable
    public Clock getClock() {
        return this.clock;
    }

    public String toString() {
        return "PubsubReadSchemaTransformConfiguration{topic=" + this.topic + ", subscription=" + this.subscription + ", format=" + this.format + ", schema=" + this.schema + ", attributes=" + this.attributes + ", attributesMap=" + this.attributesMap + ", idAttribute=" + this.idAttribute + ", timestampAttribute=" + this.timestampAttribute + ", errorHandling=" + this.errorHandling + ", clientFactory=" + this.clientFactory + ", clock=" + this.clock + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubReadSchemaTransformConfiguration) {
            PubsubReadSchemaTransformConfiguration that = (PubsubReadSchemaTransformConfiguration)o;
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && (this.subscription == null ? that.getSubscription() == null : this.subscription.equals(that.getSubscription())) && this.format.equals(that.getFormat()) && this.schema.equals(that.getSchema()) && (this.attributes == null ? that.getAttributes() == null : this.attributes.equals(that.getAttributes())) && (this.attributesMap == null ? that.getAttributesMap() == null : this.attributesMap.equals(that.getAttributesMap())) && (this.idAttribute == null ? that.getIdAttribute() == null : this.idAttribute.equals(that.getIdAttribute())) && (this.timestampAttribute == null ? that.getTimestampAttribute() == null : this.timestampAttribute.equals(that.getTimestampAttribute())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling())) && (this.clientFactory == null ? that.getClientFactory() == null : this.clientFactory.equals(that.getClientFactory())) && (this.clock == null ? that.getClock() == null : this.clock.equals(that.getClock()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic == null ? 0 : this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscription == null ? 0 : this.subscription.hashCode();
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes == null ? 0 : this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributesMap == null ? 0 : this.attributesMap.hashCode();
        h$ *= 1000003;
        h$ ^= this.idAttribute == null ? 0 : this.idAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampAttribute == null ? 0 : this.timestampAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientFactory == null ? 0 : this.clientFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.clock == null ? 0 : this.clock.hashCode();
    }

    static final class Builder
    extends PubsubReadSchemaTransformConfiguration.Builder {
        private String topic;
        private String subscription;
        private String format;
        private String schema;
        private List<String> attributes;
        private String attributesMap;
        private String idAttribute;
        private String timestampAttribute;
        private PubsubReadSchemaTransformConfiguration.ErrorHandling errorHandling;
        private PubsubTestClient.PubsubTestClientFactory clientFactory;
        private Clock clock;

        Builder() {
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setSubscription(@Nullable String subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            if (schema == null) {
                throw new NullPointerException("Null schema");
            }
            this.schema = schema;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setAttributes(@Nullable List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setAttributesMap(@Nullable String attributesMap) {
            this.attributesMap = attributesMap;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setIdAttribute(@Nullable String idAttribute) {
            this.idAttribute = idAttribute;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setTimestampAttribute(@Nullable String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setErrorHandling(@Nullable PubsubReadSchemaTransformConfiguration.ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setClientFactory(@Nullable PubsubTestClient.PubsubTestClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setClock(@Nullable Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration build() {
            if (this.format == null || this.schema == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.schema == null) {
                    missing.append(" schema");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubReadSchemaTransformConfiguration(this.topic, this.subscription, this.format, this.schema, this.attributes, this.attributesMap, this.idAttribute, this.timestampAttribute, this.errorHandling, this.clientFactory, this.clock);
        }
    }
}

