/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadSpannerSchema
extends DoFn<Void, SpannerSchema> {
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> dialectView;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedTableNames;
    private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;

    public ReadSpannerSchema(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> dialectView) {
        this(config, dialectView, new HashSet<String>());
    }

    public ReadSpannerSchema(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> dialectView, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedTableNames) {
        this.config = config;
        this.dialectView = dialectView;
        this.allowedTableNames = allowedTableNames == null ? new HashSet() : allowedTableNames;
    }

    @DoFn.Setup
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
    }

    @DoFn.Teardown
    public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Dialect dialect = (Dialect)c.sideInput(this.dialectView);
        SpannerSchema.Builder builder = SpannerSchema.builder(dialect);
        DatabaseClient databaseClient = this.spannerAccessor.getDatabaseClient();
        try (ReadOnlyTransaction tx = databaseClient.readOnlyTransaction();){
            String columnName;
            String tableName;
            ResultSet resultSet = this.readTableInfo(tx, dialect);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String type = resultSet.getString(2);
                long cellsMutated = resultSet.getLong(3);
                if (this.allowedTableNames.size() > 0 && !this.allowedTableNames.contains(tableName)) continue;
                builder.addColumn(tableName, columnName, type, cellsMutated);
            }
            resultSet = this.readPrimaryKeyInfo(tx, dialect);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String ordering = resultSet.getString(2);
                builder.addKeyPart(tableName, columnName, "DESC".equalsIgnoreCase(ordering));
            }
        }
        c.output((Object)builder.build());
    }

    private @UnknownKeyFor @NonNull @Initialized ResultSet readTableInfo(@UnknownKeyFor @NonNull @Initialized ReadOnlyTransaction tx, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        String statement = "";
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                statement = "SELECT    c.table_name  , c.column_name  , c.spanner_type  , (1 + COALESCE(t.indices, 0)) AS cells_mutated  FROM (    SELECT c.table_name, c.column_name, c.spanner_type, c.ordinal_position     FROM information_schema.columns as c     WHERE c.table_catalog = '' AND c.table_schema = '') AS c  LEFT OUTER JOIN (    SELECT t.table_name, t.column_name, COUNT(*) AS indices      FROM information_schema.index_columns AS t       WHERE t.index_name != 'PRIMARY_KEY' AND t.table_catalog = ''      AND t.table_schema = ''      GROUP BY t.table_name, t.column_name) AS t  USING (table_name, column_name)  ORDER BY c.table_name, c.ordinal_position";
                break;
            }
            case POSTGRESQL: {
                statement = "SELECT    c.table_name  , c.column_name  , c.spanner_type  , (1 + COALESCE(t.indices, 0)) AS cells_mutated  FROM (    SELECT c.table_name, c.column_name, c.spanner_type, c.ordinal_position      FROM information_schema.columns as c      WHERE c.table_schema='public') AS c  LEFT OUTER JOIN (    SELECT t.table_name, t.column_name, COUNT(*) AS indices      FROM information_schema.index_columns AS t       WHERE t.index_name != 'PRIMARY_KEY'      AND t.table_schema='public'      GROUP BY t.table_name, t.column_name) AS t  USING (table_name, column_name)  ORDER BY c.table_name, c.ordinal_position";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
            }
        }
        return tx.executeQuery(Statement.of((String)statement), new Options.QueryOption[0]);
    }

    private @UnknownKeyFor @NonNull @Initialized ResultSet readPrimaryKeyInfo(@UnknownKeyFor @NonNull @Initialized ReadOnlyTransaction tx, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        String statement = "";
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                statement = "SELECT t.table_name, t.column_name, t.column_ordering FROM information_schema.index_columns AS t  WHERE t.index_name = 'PRIMARY_KEY' AND t.table_catalog = '' AND t.table_schema = '' ORDER BY t.table_name, t.ordinal_position";
                break;
            }
            case POSTGRESQL: {
                statement = "SELECT t.table_name, t.column_name, t.column_ordering FROM information_schema.index_columns AS t  WHERE t.index_name = 'PRIMARY_KEY' AND t.table_schema='public' ORDER BY t.table_name, t.ordinal_position";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
            }
        }
        return tx.executeQuery(Statement.of((String)statement), new Options.QueryOption[0]);
    }
}

