/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class WritableCoderTest {
    @Test
    public void testIntWritableEncoding() throws Exception {
        IntWritable value = new IntWritable(42);
        WritableCoder coder = WritableCoder.of(IntWritable.class);
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)value);
    }

    @Test
    public void testNullWritableEncoding() throws Exception {
        NullWritable value = NullWritable.get();
        WritableCoder coder = WritableCoder.of(NullWritable.class);
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)value);
    }

    @Test
    public void testAutomaticRegistrationOfCoderProvider() throws Exception {
        MatcherAssert.assertThat((Object)CoderRegistry.createDefault().getCoder(NullWritable.class), (Matcher)Matchers.instanceOf(WritableCoder.class));
    }
}

