/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.hdfs.HadoopResourceId;
import org.apache.beam.sdks.java.io.hadoop.file.system.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.hadoop.file.system.repackaged.com.google.common.collect.ImmutableList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;

class HadoopFileSystem
extends FileSystem<HadoopResourceId> {
    @VisibleForTesting
    final org.apache.hadoop.fs.FileSystem fileSystem;

    HadoopFileSystem(Configuration configuration) throws IOException {
        this.fileSystem = org.apache.hadoop.fs.FileSystem.newInstance((Configuration)configuration);
    }

    protected List<MatchResult> match(List<String> specs) {
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (String spec : specs) {
            try {
                FileStatus[] fileStatuses = this.fileSystem.globStatus(new Path(spec));
                if (fileStatuses == null) {
                    resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, Collections.emptyList()));
                    continue;
                }
                ArrayList<MatchResult.Metadata> metadata = new ArrayList<MatchResult.Metadata>();
                for (FileStatus fileStatus : fileStatuses) {
                    if (!fileStatus.isFile()) continue;
                    URI uri = HadoopFileSystem.dropEmptyAuthority(fileStatus.getPath().toUri().toString());
                    metadata.add(MatchResult.Metadata.builder().setResourceId((ResourceId)new HadoopResourceId(uri)).setIsReadSeekEfficient(true).setSizeBytes(fileStatus.getLen()).build());
                }
                resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.OK, metadata));
            }
            catch (IOException e) {
                resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)e));
            }
        }
        return resultsBuilder.build();
    }

    protected WritableByteChannel create(HadoopResourceId resourceId, CreateOptions createOptions) throws IOException {
        return Channels.newChannel((OutputStream)this.fileSystem.create(resourceId.toPath()));
    }

    protected ReadableByteChannel open(HadoopResourceId resourceId) throws IOException {
        FileStatus fileStatus = this.fileSystem.getFileStatus(resourceId.toPath());
        return new HadoopSeekableByteChannel(fileStatus, this.fileSystem.open(resourceId.toPath()));
    }

    protected void copy(List<HadoopResourceId> srcResourceIds, List<HadoopResourceId> destResourceIds) throws IOException {
        for (int i = 0; i < srcResourceIds.size(); ++i) {
            FileUtil.copy((org.apache.hadoop.fs.FileSystem)this.fileSystem, (Path)srcResourceIds.get(i).toPath(), (org.apache.hadoop.fs.FileSystem)this.fileSystem, (Path)destResourceIds.get(i).toPath(), (boolean)false, (boolean)true, (Configuration)this.fileSystem.getConf());
        }
    }

    protected void rename(List<HadoopResourceId> srcResourceIds, List<HadoopResourceId> destResourceIds) throws IOException {
        for (int i = 0; i < srcResourceIds.size(); ++i) {
            this.fileSystem.rename(srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath());
        }
    }

    protected void delete(Collection<HadoopResourceId> resourceIds) throws IOException {
        for (HadoopResourceId resourceId : resourceIds) {
            this.fileSystem.delete(resourceId.toPath(), false);
        }
    }

    protected HadoopResourceId matchNewResource(String singleResourceSpec, boolean isDirectory) {
        if (singleResourceSpec.endsWith("/") && !isDirectory) {
            throw new IllegalArgumentException(String.format("Expected file path but received directory path %s", singleResourceSpec));
        }
        return !singleResourceSpec.endsWith("/") && isDirectory ? new HadoopResourceId(HadoopFileSystem.dropEmptyAuthority(singleResourceSpec + "/")) : new HadoopResourceId(HadoopFileSystem.dropEmptyAuthority(singleResourceSpec));
    }

    protected String getScheme() {
        return this.fileSystem.getScheme();
    }

    private static URI dropEmptyAuthority(String uriStr) {
        URI uri = URI.create(uriStr);
        String prefix = uri.getScheme() + ":///";
        if (uriStr.startsWith(prefix)) {
            return URI.create(uri.getScheme() + ":/" + uriStr.substring(prefix.length()));
        }
        return uri;
    }

    private static class HadoopSeekableByteChannel
    implements SeekableByteChannel {
        private final FileStatus fileStatus;
        private final FSDataInputStream inputStream;
        private boolean closed;

        private HadoopSeekableByteChannel(FileStatus fileStatus, FSDataInputStream inputStream) {
            this.fileStatus = fileStatus;
            this.inputStream = inputStream;
            this.closed = false;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            return this.inputStream.read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            return this.inputStream.getPos();
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            this.inputStream.seek(newPosition);
            return this;
        }

        @Override
        public long size() throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            return this.fileStatus.getLen();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.inputStream.close();
        }
    }
}

