/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.Objects;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;
import org.checkerframework.checker.nullness.qual.Nullable;

class HadoopResourceId
implements ResourceId {
    private final URI uri;

    HadoopResourceId(URI uri) {
        this.uri = uri;
    }

    public ResourceId resolve(String other, ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (Object)String.format("Expected this resource is a directory, but had [%s].", this.uri));
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            return new HadoopResourceId(this.uri.resolve(other));
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"Resolving a file with a directory path: %s", (Object)other);
            return new HadoopResourceId(this.uri.resolve(other));
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions %s", resolveOptions));
    }

    public ResourceId getCurrentDirectory() {
        return new HadoopResourceId(this.uri.getPath().endsWith("/") ? this.uri : this.uri.resolve("."));
    }

    public boolean isDirectory() {
        return this.uri.getPath().endsWith("/");
    }

    public String getFilename() {
        if (this.isDirectory()) {
            Path parentPath = new Path(this.uri).getParent();
            return parentPath == null ? null : parentPath.getName();
        }
        return new Path(this.uri).getName();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof HadoopResourceId)) {
            return false;
        }
        return Objects.equals(this.uri, ((HadoopResourceId)obj).uri);
    }

    public int hashCode() {
        return Objects.hashCode(this.uri);
    }

    Path toPath() {
        return new Path(this.uri);
    }
}

