/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_io_hadoop_file_system.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_io_hadoop_file_system.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.hdfs.HadoopResourceId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HadoopFileSystem
extends FileSystem<HadoopResourceId> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileSystem.class);
    @VisibleForTesting
    static final String LOG_CREATE_DIRECTORY = "Creating directory %s";
    @VisibleForTesting
    final org.apache.hadoop.fs.FileSystem fileSystem;

    HadoopFileSystem(Configuration configuration) throws IOException {
        this.fileSystem = org.apache.hadoop.fs.FileSystem.newInstance((Configuration)configuration);
    }

    protected List<MatchResult> match(List<String> specs) {
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (String spec : specs) {
            try {
                FileStatus[] fileStatuses = this.fileSystem.globStatus(new Path(spec));
                if (fileStatuses == null) {
                    resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, Collections.emptyList()));
                    continue;
                }
                ArrayList<MatchResult.Metadata> metadata = new ArrayList<MatchResult.Metadata>();
                for (FileStatus fileStatus : fileStatuses) {
                    if (!fileStatus.isFile()) continue;
                    URI uri = HadoopFileSystem.dropEmptyAuthority(fileStatus.getPath().toUri().toString());
                    metadata.add(MatchResult.Metadata.builder().setResourceId((ResourceId)new HadoopResourceId(uri)).setIsReadSeekEfficient(true).setSizeBytes(fileStatus.getLen()).build());
                }
                resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.OK, metadata));
            }
            catch (IOException e) {
                resultsBuilder.add(MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)e));
            }
        }
        return resultsBuilder.build();
    }

    protected WritableByteChannel create(HadoopResourceId resourceId, CreateOptions createOptions) throws IOException {
        return Channels.newChannel((OutputStream)this.fileSystem.create(resourceId.toPath()));
    }

    protected ReadableByteChannel open(HadoopResourceId resourceId) throws IOException {
        FileStatus fileStatus = this.fileSystem.getFileStatus(resourceId.toPath());
        return new HadoopSeekableByteChannel(fileStatus, this.fileSystem.open(resourceId.toPath()));
    }

    protected void copy(List<HadoopResourceId> srcResourceIds, List<HadoopResourceId> destResourceIds) throws IOException {
        for (int i = 0; i < srcResourceIds.size(); ++i) {
            boolean success = FileUtil.copy((org.apache.hadoop.fs.FileSystem)this.fileSystem, (Path)srcResourceIds.get(i).toPath(), (org.apache.hadoop.fs.FileSystem)this.fileSystem, (Path)destResourceIds.get(i).toPath(), (boolean)false, (boolean)true, (Configuration)this.fileSystem.getConf());
            if (success) continue;
            throw new IOException(String.format("Unable to copy resource %s to %s. No further information provided by underlying filesystem.", srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath()));
        }
    }

    protected void rename(List<HadoopResourceId> srcResourceIds, List<HadoopResourceId> destResourceIds) throws IOException {
        for (int i = 0; i < srcResourceIds.size(); ++i) {
            boolean success;
            Path targetDirectory = destResourceIds.get(i).toPath().getParent();
            if (!this.fileSystem.exists(targetDirectory)) {
                LOG.debug(String.format(LOG_CREATE_DIRECTORY, Path.getPathWithoutSchemeAndAuthority((Path)targetDirectory)));
                success = this.fileSystem.mkdirs(targetDirectory);
                if (!success) {
                    throw new IOException(String.format("Unable to create target directory %s. No further information provided by underlying filesystem.", targetDirectory));
                }
            }
            if (success = this.fileSystem.rename(srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath())) continue;
            if (!this.fileSystem.exists(srcResourceIds.get(i).toPath())) {
                throw new FileNotFoundException(String.format("Unable to rename resource %s to %s as source not found.", srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath()));
            }
            if (this.fileSystem.exists(destResourceIds.get(i).toPath())) {
                throw new FileAlreadyExistsException(String.format("Unable to rename resource %s to %s as destination already exists.", srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath()));
            }
            throw new IOException(String.format("Unable to rename resource %s to %s. No further information provided by underlying filesystem.", srcResourceIds.get(i).toPath(), destResourceIds.get(i).toPath()));
        }
    }

    protected void delete(Collection<HadoopResourceId> resourceIds) throws IOException {
        for (HadoopResourceId resourceId : resourceIds) {
            this.fileSystem.delete(resourceId.toPath(), false);
        }
    }

    protected HadoopResourceId matchNewResource(String singleResourceSpec, boolean isDirectory) {
        if (singleResourceSpec.endsWith("/") && !isDirectory) {
            throw new IllegalArgumentException(String.format("Expected file path but received directory path %s", singleResourceSpec));
        }
        return !singleResourceSpec.endsWith("/") && isDirectory ? new HadoopResourceId(HadoopFileSystem.dropEmptyAuthority(singleResourceSpec + "/")) : new HadoopResourceId(HadoopFileSystem.dropEmptyAuthority(singleResourceSpec));
    }

    protected String getScheme() {
        return this.fileSystem.getScheme();
    }

    private static URI dropEmptyAuthority(String uriStr) {
        URI uri = URI.create(uriStr);
        String prefix = uri.getScheme() + ":///";
        if (uriStr.startsWith(prefix)) {
            return URI.create(uri.getScheme() + ":/" + uriStr.substring(prefix.length()));
        }
        return uri;
    }

    private static class HadoopSeekableByteChannel
    implements SeekableByteChannel {
        private final FileStatus fileStatus;
        private final FSDataInputStream inputStream;
        private boolean closed;

        private HadoopSeekableByteChannel(FileStatus fileStatus, FSDataInputStream inputStream) {
            this.fileStatus = fileStatus;
            this.inputStream = inputStream;
            this.closed = false;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            int read = 0;
            read = dst.hasArray() ? this.inputStream.read(dst.array(), dst.position() + dst.arrayOffset(), dst.remaining()) : this.inputStream.read(dst);
            if (read > 0) {
                dst.position(dst.position() + read);
            }
            return read;
        }

        @Override
        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            return this.inputStream.getPos();
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            this.inputStream.seek(newPosition);
            return this;
        }

        @Override
        public long size() throws IOException {
            if (this.closed) {
                throw new IOException("Channel is closed");
            }
            return this.fileStatus.getLen();
        }

        @Override
        public SeekableByteChannel truncate(long size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.inputStream.close();
        }
    }
}

