/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase.repackaged.com.google.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.annotations.Beta;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.annotations.GwtCompatible;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.cache.Cache;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.cache.CacheStats;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.collect.Maps;

@Beta
@GwtCompatible
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object key : keys) {
            if (result.containsKey(key)) continue;
            Object castKey = key;
            result.put(castKey, this.getIfPresent(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public void put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.invalidate(key);
        }
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    @Beta
    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong loadSuccessCount = new AtomicLong();
        private final AtomicLong loadExceptionCount = new AtomicLong();
        private final AtomicLong totalLoadTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        @Override
        public void recordHits(int count) {
            this.hitCount.addAndGet(count);
        }

        @Override
        public void recordMisses(int count) {
            this.missCount.addAndGet(count);
        }

        @Override
        public void recordLoadSuccess(long loadTime) {
            this.loadSuccessCount.incrementAndGet();
            this.totalLoadTime.addAndGet(loadTime);
        }

        @Override
        public void recordLoadException(long loadTime) {
            this.loadExceptionCount.incrementAndGet();
            this.totalLoadTime.addAndGet(loadTime);
        }

        @Override
        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }

        @Override
        public CacheStats snapshot() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), this.loadExceptionCount.get(), this.totalLoadTime.get(), this.evictionCount.get());
        }

        public void incrementBy(StatsCounter other) {
            CacheStats otherStats = other.snapshot();
            this.hitCount.addAndGet(otherStats.hitCount());
            this.missCount.addAndGet(otherStats.missCount());
            this.loadSuccessCount.addAndGet(otherStats.loadSuccessCount());
            this.loadExceptionCount.addAndGet(otherStats.loadExceptionCount());
            this.totalLoadTime.addAndGet(otherStats.totalLoadTime());
            this.evictionCount.addAndGet(otherStats.evictionCount());
        }
    }

    @Beta
    public static interface StatsCounter {
        public void recordHits(int var1);

        public void recordMisses(int var1);

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordEviction();

        public CacheStats snapshot();
    }
}

