/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase.repackaged.com.google.common.hash;

import java.math.RoundingMode;
import java.util.Arrays;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.hash.BloomFilter;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.hash.Funnel;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.hash.Hashing;
import org.apache.beam.sdk.io.hbase.repackaged.com.google.common.math.IntMath;

enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= bits.set(nextHash % bits.size());
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                if (bits.get(nextHash % bits.size())) continue;
                return false;
            }
            return true;
        }
    };


    static class BitArray {
        final long[] data;

        BitArray(int bits) {
            this(new long[IntMath.divide(bits, 64, RoundingMode.CEILING)]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument(data.length > 0, "data length is zero!");
            this.data = data;
        }

        boolean set(int index) {
            boolean wasSet = this.get(index);
            int n = index >> 6;
            this.data[n] = this.data[n] | 1L << index;
            return !wasSet;
        }

        boolean get(int index) {
            return (this.data[index >> 6] & 1L << index) != 0L;
        }

        int size() {
            return this.data.length * 64;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

