/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.hbase.HBaseQuery;
import org.apache.beam.sdk.io.hbase.HBaseUtils;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ByteKeyRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;

@DoFn.BoundedPerElement
class HBaseReadSplittableDoFn
extends DoFn<HBaseQuery, Result> {
    private final SerializableConfiguration serializableConfiguration;
    private transient Connection connection;

    HBaseReadSplittableDoFn(SerializableConfiguration serializableConfiguration) {
        this.serializableConfiguration = serializableConfiguration;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.connection = ConnectionFactory.createConnection((Configuration)this.serializableConfiguration.get());
    }

    private static Scan newScanInRange(Scan scan, ByteKeyRange range) throws IOException {
        return new Scan(scan).setStartRow(range.getStartKey().getBytes()).setStopRow(range.getEndKey().getBytes());
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, RestrictionTracker<ByteKeyRange, ByteKey> tracker) throws Exception {
        HBaseQuery query = (HBaseQuery)c.element();
        TableName tableName = TableName.valueOf((String)query.getTableId());
        Table table = this.connection.getTable(tableName);
        ByteKeyRange range = (ByteKeyRange)tracker.currentRestriction();
        try (ResultScanner scanner = table.getScanner(HBaseReadSplittableDoFn.newScanInRange(query.getScan(), range));){
            for (Result result : scanner) {
                ByteKey key = ByteKey.copyFrom((byte[])result.getRow());
                if (!tracker.tryClaim((Object)key)) {
                    return;
                }
                c.output((Object)result);
            }
            tracker.tryClaim((Object)ByteKey.EMPTY);
        }
    }

    @DoFn.GetInitialRestriction
    public ByteKeyRange getInitialRestriction(HBaseQuery query) {
        return ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])query.getScan().getStartRow()), (ByteKey)ByteKey.copyFrom((byte[])query.getScan().getStopRow()));
    }

    @DoFn.SplitRestriction
    public void splitRestriction(HBaseQuery query, ByteKeyRange range, DoFn.OutputReceiver<ByteKeyRange> receiver) throws Exception {
        List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(this.connection, query.getTableId(), query.getScan());
        List<ByteKeyRange> splitRanges = HBaseUtils.getRanges(regionLocations, query.getTableId(), query.getScan());
        for (ByteKeyRange splitRange : splitRanges) {
            receiver.output((Object)ByteKeyRange.of((ByteKey)splitRange.getStartKey(), (ByteKey)splitRange.getEndKey()));
        }
    }

    @DoFn.NewTracker
    public ByteKeyRangeTracker newTracker(ByteKeyRange range) {
        return ByteKeyRangeTracker.of((ByteKeyRange)range);
    }

    @DoFn.Teardown
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }
}

