/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.util.List;
import org.apache.beam.sdk.io.hbase.HBaseIO;
import org.apache.beam.sdk.io.hbase.HBaseUtils;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ByteKeyRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DoFn.BoundedPerElement
class HBaseReadSplittableDoFn
extends DoFn<HBaseIO.Read, Result> {
    HBaseReadSplittableDoFn() {
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element  @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Result> out, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized ByteKeyRange, @UnknownKeyFor @NonNull @Initialized ByteKey> tracker) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)read.getConfiguration());
        TableName tableName = TableName.valueOf((String)read.getTableId());
        Table table = connection.getTable(tableName);
        ByteKeyRange range = (ByteKeyRange)tracker.currentRestriction();
        try (ResultScanner scanner = table.getScanner(HBaseUtils.newScanInRange(read.getScan(), range));){
            for (Result result : scanner) {
                ByteKey key = ByteKey.copyFrom((byte[])result.getRow());
                if (!tracker.tryClaim((Object)key)) {
                    return;
                }
                out.output((Object)result);
            }
            tracker.tryClaim((Object)ByteKey.EMPTY);
        }
    }

    @DoFn.GetInitialRestriction
    public @UnknownKeyFor @NonNull @Initialized ByteKeyRange getInitialRestriction(@DoFn.Element  @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read) {
        return HBaseUtils.getByteKeyRange(read.getScan());
    }

    @DoFn.SplitRestriction
    public void splitRestriction(@DoFn.Element  @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized ByteKeyRange range, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)read.getConfiguration());
        List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(connection, read.getTableId(), range);
        List<ByteKeyRange> splitRanges = HBaseUtils.getRanges(regionLocations, read.getTableId(), range);
        for (ByteKeyRange splitRange : splitRanges) {
            receiver.output((Object)ByteKeyRange.of((ByteKey)splitRange.getStartKey(), (ByteKey)splitRange.getEndKey()));
        }
    }

    @DoFn.NewTracker
    public @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        return ByteKeyRangeTracker.of((ByteKeyRange)range);
    }
}

