/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.util.List;
import org.apache.beam.sdk.io.hbase.HBaseIO;
import org.apache.beam.sdk.io.hbase.HBaseUtils;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ByteKeyRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;

@DoFn.BoundedPerElement
class HBaseReadSplittableDoFn
extends DoFn<HBaseIO.Read, Result> {
    HBaseReadSplittableDoFn() {
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element HBaseIO.Read read, DoFn.OutputReceiver<Result> out, RestrictionTracker<ByteKeyRange, ByteKey> tracker) throws Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)read.getConfiguration());
        TableName tableName = TableName.valueOf((String)read.getTableId());
        Table table = connection.getTable(tableName);
        ByteKeyRange range = (ByteKeyRange)tracker.currentRestriction();
        try (ResultScanner scanner = table.getScanner(HBaseUtils.newScanInRange(read.getScan(), range));){
            for (Result result : scanner) {
                ByteKey key = ByteKey.copyFrom((byte[])result.getRow());
                if (!tracker.tryClaim((Object)key)) {
                    return;
                }
                out.output((Object)result);
            }
            tracker.tryClaim((Object)ByteKey.EMPTY);
        }
    }

    @DoFn.GetInitialRestriction
    public ByteKeyRange getInitialRestriction(@DoFn.Element HBaseIO.Read read) {
        return HBaseUtils.getByteKeyRange(read.getScan());
    }

    @DoFn.SplitRestriction
    public void splitRestriction(@DoFn.Element HBaseIO.Read read, @DoFn.Restriction ByteKeyRange range, DoFn.OutputReceiver<ByteKeyRange> receiver) throws Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)read.getConfiguration());
        List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(connection, read.getTableId(), range);
        List<ByteKeyRange> splitRanges = HBaseUtils.getRanges(regionLocations, read.getTableId(), range);
        for (ByteKeyRange splitRange : splitRanges) {
            receiver.output((Object)ByteKeyRange.of((ByteKey)splitRange.getStartKey(), (ByteKey)splitRange.getEndKey()));
        }
    }

    @DoFn.NewTracker
    public ByteKeyRangeTracker newTracker(@DoFn.Restriction ByteKeyRange range) {
        return ByteKeyRangeTracker.of((ByteKeyRange)range);
    }
}

